/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.model;

import io.vavr.Tuple;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.LongStreamEx;
import one.util.streamex.StreamEx;

public enum TypeMappings {
    COLLECTION(Collection.class, d -> StreamEx.of((Collection)((Collection)d))),
    MAP(Map.class, d -> EntryStream.of((Map)((Map)d)).mapKeyValue(AbstractMap.SimpleEntry::new)),
    ENTRY(Map.Entry.class, d -> StreamEx.of((Object[])new Object[]{((Map.Entry)d).getKey(), ((Map.Entry)d).getValue()})),
    OBJECT_ARRAY(Object[].class, d -> StreamEx.of((Object[])((Object[])d))),
    DOUBLE_ARRAY(double[].class, d -> DoubleStreamEx.of((double[])((double[])d)).boxed()),
    INT_ARRAY(int[].class, d -> IntStreamEx.of((int[])((int[])d)).boxed()),
    LONG_ARRAY(long[].class, d -> LongStreamEx.of((long[])((long[])d)).boxed()),
    STREAM(Stream.class, d -> StreamEx.of((Stream)((Stream)d))),
    TUPLE(Tuple.class, d -> StreamEx.of((Object[])((Tuple)d).toSeq().toJavaArray()));

    private final Class<?> typeClass;
    private final Function<Object, StreamEx<?>> mapper;

    public boolean isInstanceOf(Object ob) {
        return ob != null && this.typeClass.isAssignableFrom(ob.getClass());
    }

    public <T> StreamEx<T> streamOf(T ob) {
        return this.mapper.apply(ob);
    }

    private TypeMappings(Class<?> typeClass, Function<Object, StreamEx<?>> mapper) {
        this.typeClass = typeClass;
        this.mapper = mapper;
    }
}

