/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.model;

import io.github.sskorol.core.DataSupplier;
import io.github.sskorol.utils.ReflectionUtils;
import io.vavr.API;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;

public class TestNGMethod {
    private final ITestNGMethod testMethod;
    private final Method dataSupplierMethod;
    private final ITestContext context;
    private final DataSupplier dataSupplier;

    public TestNGMethod(ITestContext context, ITestNGMethod testMethod) {
        this.context = context;
        this.testMethod = testMethod;
        this.dataSupplierMethod = ReflectionUtils.findDataSupplier(testMethod);
        this.dataSupplier = this.dataSupplierMethod.getDeclaredAnnotation(DataSupplier.class);
    }

    public <T> T getDataSupplierArg(Function<DataSupplier, T> mapper, T other) {
        return Optional.ofNullable(this.dataSupplier).map(mapper).orElse(other);
    }

    public Tuple2<Method, Object[]> getDataSupplierMetaData() {
        return Tuple.of((Object)this.dataSupplierMethod, (Object)Arrays.stream(this.dataSupplierMethod.getParameterTypes()).map(t -> API.Match((Object)t).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$(ITestContext.class), () -> this.context), API.Case((API.Match.Pattern0)API.$(Method.class), () -> this.testMethod.getConstructorOrMethod().getMethod()), API.Case((API.Match.Pattern0)API.$(ITestNGMethod.class), () -> this.testMethod), API.Case((API.Match.Pattern0)API.$(), () -> null)})).toArray());
    }

    public ITestNGMethod getTestMethod() {
        return this.testMethod;
    }

    public Method getDataSupplierMethod() {
        return this.dataSupplierMethod;
    }
}

