/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.configure;

import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import io.github.springboot.httpclient5.core.config.model.ConnectionManagerConfigProperties;
import io.github.springboot.httpclient5.core.configure.ConfigurableConnPoolControl;
import io.github.springboot.httpclient5.core.configure.PoolingHttpClientConnectionManagerPostConfigurer;
import java.io.IOException;
import java.util.Set;
import lombok.Generated;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HttpClientConnectionManagerConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClientConnectionManagerConfigurer.class);
    @Autowired
    private HttpClient5Config config;
    @Autowired
    private ObjectProvider<PoolingHttpClientConnectionManagerPostConfigurer> cmConfigurers;

    @Bean
    public PoolingHttpClientConnectionManager defaultConnectionManager(@Autowired(required=false) ObjectProvider<LayeredConnectionSocketFactory> sslSocketFactoryProvider, @Autowired(required=false) ObjectProvider<HttpConnectionFactory<ManagedHttpClientConnection>> httpConnectionFactory, @Autowired(required=false) ObjectProvider<SchemePortResolver> schemePortResolverProvider) {
        ConnectionManagerConfigProperties pool = this.config.getPool();
        httpConnectionFactory.ifAvailable(pool::setConnectionFactory);
        sslSocketFactoryProvider.ifAvailable(pool::setSSLSocketFactory);
        schemePortResolverProvider.ifAvailable(pool::setSchemePortResolver);
        pool.setDefaultSocketConfig(pool.getDefaultSocketConfig().build());
        if (pool.getDefaultConnectionConfig() != null) {
            pool.setDefaultConnectionConfig(pool.getDefaultConnectionConfig().build());
        }
        log.debug("Connection Manager is {}", (Object)pool);
        PoolingHttpClientConnectionManager connectionManager = pool.build();
        PoolingHttpClientConnectionManagerWrapper wrapper = new PoolingHttpClientConnectionManagerWrapper(connectionManager);
        this.cmConfigurers.orderedStream().forEach(c -> c.configure(wrapper, false));
        return connectionManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public SchemePortResolver schemePortResolver() {
        return new DefaultSchemePortResolver();
    }

    public static class PoolingHttpClientConnectionManagerWrapper
    implements ConfigurableConnPoolControl {
        private final PoolingHttpClientConnectionManager internal;

        @Generated
        public PoolingHttpClientConnectionManagerWrapper(PoolingHttpClientConnectionManager internal) {
            this.internal = internal;
        }

        @Generated
        public void close() {
            this.internal.close();
        }

        @Generated
        public void close(CloseMode closeMode) {
            this.internal.close(closeMode);
        }

        @Generated
        public LeaseRequest lease(String id, HttpRoute route, Object state) {
            return this.internal.lease(id, route, state);
        }

        @Generated
        public LeaseRequest lease(String id, HttpRoute route, Timeout requestTimeout, Object state) {
            return this.internal.lease(id, route, requestTimeout, state);
        }

        @Generated
        public void release(ConnectionEndpoint endpoint, Object state, TimeValue keepAlive) {
            this.internal.release(endpoint, state, keepAlive);
        }

        @Generated
        public void connect(ConnectionEndpoint endpoint, TimeValue timeout, HttpContext context) throws IOException {
            this.internal.connect(endpoint, timeout, context);
        }

        @Generated
        public void upgrade(ConnectionEndpoint endpoint, HttpContext context) throws IOException {
            this.internal.upgrade(endpoint, context);
        }

        @Generated
        public void closeIdle(TimeValue idleTime) {
            this.internal.closeIdle(idleTime);
        }

        @Generated
        public void closeExpired() {
            this.internal.closeExpired();
        }

        @Generated
        public Set<HttpRoute> getRoutes() {
            return this.internal.getRoutes();
        }

        @Generated
        public int getMaxTotal() {
            return this.internal.getMaxTotal();
        }

        @Generated
        public void setMaxTotal(int max) {
            this.internal.setMaxTotal(max);
        }

        @Generated
        public int getDefaultMaxPerRoute() {
            return this.internal.getDefaultMaxPerRoute();
        }

        @Generated
        public void setDefaultMaxPerRoute(int max) {
            this.internal.setDefaultMaxPerRoute(max);
        }

        @Generated
        public int getMaxPerRoute(HttpRoute route) {
            return this.internal.getMaxPerRoute(route);
        }

        @Generated
        public void setMaxPerRoute(HttpRoute route, int max) {
            this.internal.setMaxPerRoute(route, max);
        }

        @Generated
        public PoolStats getTotalStats() {
            return this.internal.getTotalStats();
        }

        @Generated
        public PoolStats getStats(HttpRoute route) {
            return this.internal.getStats(route);
        }

        @Override
        @Generated
        public void setDefaultSocketConfig(SocketConfig config) {
            this.internal.setDefaultSocketConfig(config);
        }

        @Generated
        public void setSocketConfigResolver(Resolver<HttpRoute, SocketConfig> socketConfigResolver) {
            this.internal.setSocketConfigResolver(socketConfigResolver);
        }

        @Override
        @Generated
        public void setDefaultConnectionConfig(ConnectionConfig config) {
            this.internal.setDefaultConnectionConfig(config);
        }

        @Override
        @Generated
        public void setConnectionConfigResolver(Resolver<HttpRoute, ConnectionConfig> connectionConfigResolver) {
            this.internal.setConnectionConfigResolver(connectionConfigResolver);
        }

        @Generated
        public void setDefaultTlsConfig(TlsConfig config) {
            this.internal.setDefaultTlsConfig(config);
        }

        @Generated
        public void setTlsConfigResolver(Resolver<HttpHost, TlsConfig> tlsConfigResolver) {
            this.internal.setTlsConfigResolver(tlsConfigResolver);
        }

        @Deprecated
        @Generated
        public SocketConfig getDefaultSocketConfig() {
            return this.internal.getDefaultSocketConfig();
        }

        @Deprecated
        @Generated
        public TimeValue getValidateAfterInactivity() {
            return this.internal.getValidateAfterInactivity();
        }

        @Deprecated
        @Generated
        public void setValidateAfterInactivity(TimeValue validateAfterInactivity) {
            this.internal.setValidateAfterInactivity(validateAfterInactivity);
        }

        @Generated
        public boolean isClosed() {
            return this.internal.isClosed();
        }
    }
}

