/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.configure;

import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import io.github.springboot.httpclient5.core.config.model.RequestConfigProperties;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHttpRoutePlanner
implements HttpRoutePlanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomHttpRoutePlanner.class);
    private final HttpClient5Config config;
    private final HttpRoutePlanner delegate;

    public CustomHttpRoutePlanner(HttpClient5Config config) {
        this.config = config;
        this.delegate = new DefaultRoutePlanner((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
    }

    public HttpRoute determineRoute(HttpHost target, HttpContext context) throws HttpException {
        return this.determineRoute(target, null, context);
    }

    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpClientContext clientContext = HttpClientContext.cast((HttpContext)context);
        if (request != null) {
            try {
                URI uri = request.getUri();
                String method = request.getMethod();
                RequestConfigProperties requestConfigProperties = this.config.getRequestConfigProperties(method, uri.toString());
                RequestConfig requestConfig = requestConfigProperties.build();
                clientContext.setRequestConfig(requestConfig);
            }
            catch (URISyntaxException e) {
                log.warn("Unable to configure httpclient request, no uri available : using defaut configuration", (Throwable)e);
            }
        }
        return this.delegate.determineRoute(host, request, (HttpContext)clientContext);
    }
}

