/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.springboot.httpclient5.core.config.RequestConfigCustomizer;
import io.github.springboot.httpclient5.core.config.model.AsyncConnectionManagerConfigProperties;
import io.github.springboot.httpclient5.core.config.model.CharCodingConfigProperties;
import io.github.springboot.httpclient5.core.config.model.ConnectionConfigProperties;
import io.github.springboot.httpclient5.core.config.model.ConnectionManagerConfigProperties;
import io.github.springboot.httpclient5.core.config.model.DefaultConfigConfigurer;
import io.github.springboot.httpclient5.core.config.model.Http1ConfigProperties;
import io.github.springboot.httpclient5.core.config.model.IOReactorConfigProperties;
import io.github.springboot.httpclient5.core.config.model.RequestConfigProperties;
import io.github.springboot.httpclient5.core.config.model.SocketConfigProperties;
import io.github.springboot.httpclient5.core.utils.PatternUtils;
import jakarta.annotation.PostConstruct;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ConcurrentLruCache;

@Configuration
@ConfigurationProperties(prefix="spring.httpclient5")
public class HttpClient5Config {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClient5Config.class);
    private static final int DEFAULT_MAX_CONNEXION_PER_HOST = 50;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String DEFAULT_HOST_KEY = "default";
    public static Timeout DEFAULT_CONNECT_TIMEOUT = Timeout.ofSeconds((long)3L);
    public static Timeout DEFAULT_SOCKET_TIMEOUT;
    public static Timeout DEFAULT_RESPONSE_TIMEOUT;
    public static Timeout DEFAULT_CONNECTION_REQUEST_TIMEOUT;
    @NestedConfigurationProperty
    private ConnectionManagerConfigProperties pool = new ConnectionManagerConfigProperties();
    @NestedConfigurationProperty
    private AsyncConnectionManagerConfigProperties asyncPool = new AsyncConnectionManagerConfigProperties();
    @NestedConfigurationProperty
    private Http1ConfigProperties http1 = new Http1ConfigProperties();
    @NestedConfigurationProperty
    private CharCodingConfigProperties charCoding = new CharCodingConfigProperties();
    @NestedConfigurationProperty
    private IOReactorConfigProperties ioReactor = new IOReactorConfigProperties();
    @NestedConfigurationProperty
    private Map<String, RequestConfigProperties> requestConfig = new HashMap<String, RequestConfigProperties>();
    @NestedConfigurationProperty
    private JmxConfig jmx = new JmxConfig();
    private ConcurrentLruCache<Pair<String, String>, RequestConfigProperties> requestConfigPropertiesCache = new ConcurrentLruCache(10240, this::getRequestConfigProperties);
    private String userAgent;
    private boolean autoconfig = true;
    @Autowired(required=false)
    private RequestConfigCustomizer requestConfigCustomizer = RequestConfigCustomizer.NOOP;
    @Autowired
    ConfigurableEnvironment env;

    public String toString() {
        return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(this.requestConfig);
    }

    @PostConstruct
    public void init() {
        HashMap<String, RequestConfigProperties> erc = new HashMap<String, RequestConfigProperties>();
        this.requestConfig.forEach((k, v) -> erc.put(this.env.resolvePlaceholders(k), (RequestConfigProperties)v));
        this.requestConfig = erc;
        HashMap<String, ConnectionConfigProperties> ehc = new HashMap<String, ConnectionConfigProperties>();
        this.pool.getHostConfig().forEach((k, v) -> ehc.put(this.normalizeAndExpandHost((String)k), (ConnectionConfigProperties)v));
        this.pool.setHostConfig(ehc);
        HashMap<String, ConnectionConfigProperties> ehcAsync = new HashMap<String, ConnectionConfigProperties>();
        this.asyncPool.getHostConfig().forEach((k, v) -> ehcAsync.put(this.normalizeAndExpandHost((String)k), (ConnectionConfigProperties)v));
        this.asyncPool.setHostConfig(ehcAsync);
        if (this.autoconfig) {
            if (this.requestConfig.isEmpty()) {
                RequestConfigProperties defaultRequestConfig = new RequestConfigProperties();
                defaultRequestConfig.setResponseTimeout(DEFAULT_RESPONSE_TIMEOUT);
                defaultRequestConfig.setConnectionRequestTimeout(DEFAULT_CONNECTION_REQUEST_TIMEOUT);
                this.requestConfig.put(DEFAULT_HOST_KEY, defaultRequestConfig);
            }
            this.managedDefaultsOnZeroConf(this.pool);
            this.managedDefaultsOnZeroConf(this.asyncPool);
        }
    }

    private String normalizeAndExpandHost(String uri) {
        try {
            HttpHost httpHost = HttpHost.create((String)this.env.resolvePlaceholders(uri));
            if (httpHost.getPort() == -1) {
                httpHost = "https".equals(httpHost.getSchemeName()) ? HttpHost.create((String)this.env.resolvePlaceholders(uri + ":443")) : HttpHost.create((String)this.env.resolvePlaceholders(uri + ":80"));
            }
            return httpHost.toURI();
        }
        catch (URISyntaxException e) {
            return uri;
        }
    }

    private void managedDefaultsOnZeroConf(DefaultConfigConfigurer cpool) {
        if (!this.hasMaxConnPerRouteConfigured()) {
            cpool.setMaxConnPerRoute(50);
            cpool.setPoolConcurrencyPolicy(PoolConcurrencyPolicy.LAX);
        }
        if (cpool.getDefaultConnectionConfig() == null) {
            ConnectionConfigProperties connectionConfig = new ConnectionConfigProperties();
            connectionConfig.setConnectTimeout(DEFAULT_CONNECT_TIMEOUT);
            connectionConfig.setSocketTimeout(DEFAULT_SOCKET_TIMEOUT);
            connectionConfig.setTimeToLive(TimeValue.ofSeconds((long)120L));
            connectionConfig.setValidateAfterInactivity((TimeValue)Timeout.ofSeconds((long)20L));
            cpool.setDefaultConnectionConfig(connectionConfig);
        }
        if (cpool.getDefaultSocketConfig() == null) {
            SocketConfigProperties socketConfig = new SocketConfigProperties();
            socketConfig.setSoTimeout(DEFAULT_SOCKET_TIMEOUT);
            cpool.setDefaultSocketConfig(socketConfig);
        }
    }

    private boolean hasMaxConnPerRouteConfigured() {
        return this.env.getProperty("spring.httpclient5.pool.max-connper-route", Integer.class) != null || this.env.getProperty("spring.httpclient5.async-pool.max-connper-route", Integer.class) != null;
    }

    public RequestConfig getRequestConfig(String method, String uri) {
        return this.getRequestConfigProperties(method, uri).build();
    }

    public RequestConfigProperties getRequestConfigProperties(String method, String uri) {
        RequestConfigProperties properties = new RequestConfigProperties((RequestConfigProperties)this.requestConfigPropertiesCache.get((Object)Pair.of((Object)method, (Object)uri)));
        return this.requestConfigCustomizer.customizeRequestConfigProperties(method, uri, properties);
    }

    private RequestConfigProperties getRequestConfigProperties(Pair<String, String> key) {
        String methodAndUrl = (String)key.getLeft() + " " + (String)key.getRight();
        RequestConfigProperties initial = this.getDefaultRequestConfig();
        RequestConfigProperties res = this.getRequestConfig().entrySet().stream().filter(e -> PatternUtils.matches(methodAndUrl, (String)e.getKey())).sorted(this::byMatcherPrecision).map(hc -> (RequestConfigProperties)hc.getValue()).reduce(initial, (current, toApply) -> {
            log.debug("Applying request config for {}", (Object)key);
            return current.apply((RequestConfigProperties)toApply);
        });
        return res;
    }

    public RequestConfigProperties getDefaultRequestConfig() {
        return new RequestConfigProperties(this.requestConfig.get(DEFAULT_HOST_KEY));
    }

    private int byMatcherPrecision(Map.Entry<String, RequestConfigProperties> a, Map.Entry<String, RequestConfigProperties> b) {
        return a.getKey().compareTo(b.getKey());
    }

    @Generated
    public HttpClient5Config() {
    }

    @Generated
    public ConnectionManagerConfigProperties getPool() {
        return this.pool;
    }

    @Generated
    public AsyncConnectionManagerConfigProperties getAsyncPool() {
        return this.asyncPool;
    }

    @Generated
    public Http1ConfigProperties getHttp1() {
        return this.http1;
    }

    @Generated
    public CharCodingConfigProperties getCharCoding() {
        return this.charCoding;
    }

    @Generated
    public IOReactorConfigProperties getIoReactor() {
        return this.ioReactor;
    }

    @Generated
    public Map<String, RequestConfigProperties> getRequestConfig() {
        return this.requestConfig;
    }

    @Generated
    public JmxConfig getJmx() {
        return this.jmx;
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public boolean isAutoconfig() {
        return this.autoconfig;
    }

    @Generated
    public RequestConfigCustomizer getRequestConfigCustomizer() {
        return this.requestConfigCustomizer;
    }

    @Generated
    public ConfigurableEnvironment getEnv() {
        return this.env;
    }

    @Generated
    public void setPool(ConnectionManagerConfigProperties pool) {
        this.pool = pool;
    }

    @Generated
    public void setAsyncPool(AsyncConnectionManagerConfigProperties asyncPool) {
        this.asyncPool = asyncPool;
    }

    @Generated
    public void setHttp1(Http1ConfigProperties http1) {
        this.http1 = http1;
    }

    @Generated
    public void setCharCoding(CharCodingConfigProperties charCoding) {
        this.charCoding = charCoding;
    }

    @Generated
    public void setIoReactor(IOReactorConfigProperties ioReactor) {
        this.ioReactor = ioReactor;
    }

    @Generated
    public void setRequestConfig(Map<String, RequestConfigProperties> requestConfig) {
        this.requestConfig = requestConfig;
    }

    @Generated
    public void setJmx(JmxConfig jmx) {
        this.jmx = jmx;
    }

    @Generated
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Generated
    public void setAutoconfig(boolean autoconfig) {
        this.autoconfig = autoconfig;
    }

    @Generated
    public void setRequestConfigCustomizer(RequestConfigCustomizer requestConfigCustomizer) {
        this.requestConfigCustomizer = requestConfigCustomizer;
    }

    @Generated
    public void setEnv(ConfigurableEnvironment env) {
        this.env = env;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClient5Config)) {
            return false;
        }
        HttpClient5Config other = (HttpClient5Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoconfig() != other.isAutoconfig()) {
            return false;
        }
        ConnectionManagerConfigProperties this$pool = this.getPool();
        ConnectionManagerConfigProperties other$pool = other.getPool();
        if (this$pool == null ? other$pool != null : !this$pool.equals(other$pool)) {
            return false;
        }
        AsyncConnectionManagerConfigProperties this$asyncPool = this.getAsyncPool();
        AsyncConnectionManagerConfigProperties other$asyncPool = other.getAsyncPool();
        if (this$asyncPool == null ? other$asyncPool != null : !this$asyncPool.equals(other$asyncPool)) {
            return false;
        }
        Http1ConfigProperties this$http1 = this.getHttp1();
        Http1ConfigProperties other$http1 = other.getHttp1();
        if (this$http1 == null ? other$http1 != null : !this$http1.equals(other$http1)) {
            return false;
        }
        CharCodingConfigProperties this$charCoding = this.getCharCoding();
        CharCodingConfigProperties other$charCoding = other.getCharCoding();
        if (this$charCoding == null ? other$charCoding != null : !this$charCoding.equals(other$charCoding)) {
            return false;
        }
        IOReactorConfigProperties this$ioReactor = this.getIoReactor();
        IOReactorConfigProperties other$ioReactor = other.getIoReactor();
        if (this$ioReactor == null ? other$ioReactor != null : !this$ioReactor.equals(other$ioReactor)) {
            return false;
        }
        Map<String, RequestConfigProperties> this$requestConfig = this.getRequestConfig();
        Map<String, RequestConfigProperties> other$requestConfig = other.getRequestConfig();
        if (this$requestConfig == null ? other$requestConfig != null : !((Object)this$requestConfig).equals(other$requestConfig)) {
            return false;
        }
        JmxConfig this$jmx = this.getJmx();
        JmxConfig other$jmx = other.getJmx();
        if (this$jmx == null ? other$jmx != null : !((Object)this$jmx).equals(other$jmx)) {
            return false;
        }
        ConcurrentLruCache<Pair<String, String>, RequestConfigProperties> this$requestConfigPropertiesCache = this.requestConfigPropertiesCache;
        ConcurrentLruCache<Pair<String, String>, RequestConfigProperties> other$requestConfigPropertiesCache = other.requestConfigPropertiesCache;
        if (this$requestConfigPropertiesCache == null ? other$requestConfigPropertiesCache != null : !this$requestConfigPropertiesCache.equals(other$requestConfigPropertiesCache)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        RequestConfigCustomizer this$requestConfigCustomizer = this.getRequestConfigCustomizer();
        RequestConfigCustomizer other$requestConfigCustomizer = other.getRequestConfigCustomizer();
        if (this$requestConfigCustomizer == null ? other$requestConfigCustomizer != null : !this$requestConfigCustomizer.equals(other$requestConfigCustomizer)) {
            return false;
        }
        ConfigurableEnvironment this$env = this.getEnv();
        ConfigurableEnvironment other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpClient5Config;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoconfig() ? 79 : 97);
        ConnectionManagerConfigProperties $pool = this.getPool();
        result = result * 59 + ($pool == null ? 43 : $pool.hashCode());
        AsyncConnectionManagerConfigProperties $asyncPool = this.getAsyncPool();
        result = result * 59 + ($asyncPool == null ? 43 : $asyncPool.hashCode());
        Http1ConfigProperties $http1 = this.getHttp1();
        result = result * 59 + ($http1 == null ? 43 : $http1.hashCode());
        CharCodingConfigProperties $charCoding = this.getCharCoding();
        result = result * 59 + ($charCoding == null ? 43 : $charCoding.hashCode());
        IOReactorConfigProperties $ioReactor = this.getIoReactor();
        result = result * 59 + ($ioReactor == null ? 43 : $ioReactor.hashCode());
        Map<String, RequestConfigProperties> $requestConfig = this.getRequestConfig();
        result = result * 59 + ($requestConfig == null ? 43 : ((Object)$requestConfig).hashCode());
        JmxConfig $jmx = this.getJmx();
        result = result * 59 + ($jmx == null ? 43 : ((Object)$jmx).hashCode());
        ConcurrentLruCache<Pair<String, String>, RequestConfigProperties> $requestConfigPropertiesCache = this.requestConfigPropertiesCache;
        result = result * 59 + ($requestConfigPropertiesCache == null ? 43 : $requestConfigPropertiesCache.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        RequestConfigCustomizer $requestConfigCustomizer = this.getRequestConfigCustomizer();
        result = result * 59 + ($requestConfigCustomizer == null ? 43 : $requestConfigCustomizer.hashCode());
        ConfigurableEnvironment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    static {
        DEFAULT_RESPONSE_TIMEOUT = DEFAULT_SOCKET_TIMEOUT = Timeout.ofSeconds((long)30L);
        DEFAULT_CONNECTION_REQUEST_TIMEOUT = DEFAULT_CONNECT_TIMEOUT;
    }

    public static class JmxConfig {
        private String domain = "default";
        private String metricNameStrategy = "HOST_AND_METHOD";

        @Generated
        public JmxConfig() {
        }

        @Generated
        public String getDomain() {
            return this.domain;
        }

        @Generated
        public String getMetricNameStrategy() {
            return this.metricNameStrategy;
        }

        @Generated
        public void setDomain(String domain) {
            this.domain = domain;
        }

        @Generated
        public void setMetricNameStrategy(String metricNameStrategy) {
            this.metricNameStrategy = metricNameStrategy;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JmxConfig)) {
                return false;
            }
            JmxConfig other = (JmxConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$domain = this.getDomain();
            String other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            String this$metricNameStrategy = this.getMetricNameStrategy();
            String other$metricNameStrategy = other.getMetricNameStrategy();
            return !(this$metricNameStrategy == null ? other$metricNameStrategy != null : !this$metricNameStrategy.equals(other$metricNameStrategy));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JmxConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            String $metricNameStrategy = this.getMetricNameStrategy();
            result = result * 59 + ($metricNameStrategy == null ? 43 : $metricNameStrategy.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HttpClient5Config.JmxConfig(domain=" + this.getDomain() + ", metricNameStrategy=" + this.getMetricNameStrategy() + ")";
        }
    }
}

