/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis.concurrent;

import io.github.spring.tools.redis.IRedisLock;
import io.github.spring.tools.redis.RedisLockBuilder;
import io.github.spring.tools.redis.RedisLockClient;
import io.github.spring.tools.redis.capable.ILockWritable;
import io.github.spring.tools.redis.concurrent.RateLimiterData;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedisRateLimiter {
    private static final Logger log = LoggerFactory.getLogger(RedisRateLimiter.class);
    private double permitsPerSecond;
    private double maxPermits;
    private double initStoredPermits;
    private RateLimiterData limiterData;
    private String key;
    private RedisLockClient redisLockClient;
    private static final String DATA_KEY_PREFIX = "RedisRateLimiterKey:";

    private RedisRateLimiter(double permitsPerSecond, double maxPermits, double initStoredPermits, String key) {
        this.permitsPerSecond = permitsPerSecond;
        this.maxPermits = maxPermits;
        this.initStoredPermits = initStoredPermits;
        this.key = key;
    }

    private static void checkArgument(boolean b, String errorMessageTemplate) {
        if (!b) {
            throw new IllegalArgumentException(errorMessageTemplate);
        }
    }

    public boolean tryAcquire(int permits) {
        try {
            return this.tryAcquire(permits, 0, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long tryGetAllPermits() {
        try (IRedisLock redisLock = RedisLockBuilder.builder(this.key).lockSeconds(this.getLockSeconds(0L)).build();){
            if (!redisLock.tryLock()) return 0L;
            long nowMills = this.currentRedisTime();
            long usedMills = System.currentTimeMillis();
            this.restore(nowMills);
            usedMills = System.currentTimeMillis() - usedMills;
            long getPerimts = Double.valueOf(this.limiterData.getStoredPermits()).intValue();
            if (getPerimts > 0L) {
                this.syncToRedis(getPerimts, nowMills + usedMills);
            }
            long l = getPerimts;
            return l;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    public boolean tryAcquire(int permits, int timeout, TimeUnit unit) throws Exception {
        Objects.requireNonNull(this.key);
        Objects.requireNonNull(unit);
        timeout = Math.max(0, timeout);
        long timeoutMills = Math.max(unit.toMillis(timeout), 0L);
        RedisRateLimiter.checkPermits(permits);
        long millsToWait = 0L;
        long startLockMills = System.currentTimeMillis();
        try (IRedisLock redisLock = RedisLockBuilder.builder(this.key).lockSeconds(this.getLockSeconds(timeoutMills)).build();){
            if (timeout > 0 ? redisLock.tryLock(timeout, unit) : redisLock.tryLock()) {
                long nowMills = this.currentRedisTime();
                this.restore(nowMills);
                long lockUsedMills = System.currentTimeMillis() - startLockMills;
                if (!this.canAcquire(permits, nowMills, timeoutMills) && timeout == 0) {
                    this.debug(String.format("\u83b7\u53d6\u5931\u8d25\uff0c\u5b58%s,\u9700%s", this.limiterData.getStoredPermits(), permits));
                    boolean bl = false;
                    return bl;
                }
                millsToWait = this.getWaitLength(permits, nowMills);
                this.debug(String.format("\u5f53\u524d\u5e93\u5b58\u4e0d\u8db3\uff0c\u9700\u7b49\u5f85 %s \u6beb\u79d2", millsToWait));
                if (millsToWait > 0L && unit.toMillis(timeout) - lockUsedMills - millsToWait < 0L) {
                    this.debug(String.format("\u7b49\u5f85\u65f6\u95f4\u5185\u4e0d\u8db3\u4ee5\u83b7\u53d6\uff0c\u7b49\u5f85\u65f6\u95f4 %s \u6beb\u79d2\uff0c\u83b7\u53d6\u6b64 %s \u4ee4\u724c\u6570\u91cf\u9700 %s \u6beb\u79d2", unit.toMillis(timeout), permits, millsToWait + lockUsedMills));
                    boolean bl = false;
                    return bl;
                }
                if (millsToWait > 0L) {
                    this.debug(String.format("\u7b49\u5f85 %s \u6beb\u79d2\u53ef\u53d6\u5f97\u4ee4\u724c,%s,%s,%s", millsToWait, unit.toMillis(timeout), this.limiterData.getNextFreeTicketMill(), lockUsedMills));
                    Thread.sleep(millsToWait);
                    nowMills += millsToWait + lockUsedMills;
                }
                this.syncToRedis(permits, nowMills);
                this.debug(String.format(" tostring is %s", this.limiterData.toString()));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private int getLockSeconds(long timeoutMills) {
        return timeoutMills == 0L ? 10 : (int)Math.max(TimeUnit.MILLISECONDS.toSeconds(timeoutMills) * 10L, 10L);
    }

    private boolean canAcquire(int permits, long nowMills, long timeoutMills) {
        this.debug(String.format("\u5c1d\u8bd5\u76f4\u63a5\u83b7\u53d6\u5b58\u50a8\u7684\u4ee4\u724c[\u5b58%s,\u9700:%s]", this.limiterData.getStoredPermits(), permits));
        return (double)permits <= this.limiterData.getStoredPermits();
    }

    private long currentRedisTime() {
        return this.redisLockClient.queryRedisNow();
    }

    private static void checkPermits(int permits) {
        RedisRateLimiter.checkArgument(permits > 0, String.format("Requested permits (%s) must be positive", permits));
    }

    private void syncToRedis(long permites, long now) {
        this.limiterData.acquire(permites, now);
        this.redisLockClient.set(this.newKey(), this.limiterData.toArrayString(), true);
    }

    private String newKey() {
        return String.format("%s%s", DATA_KEY_PREFIX, this.key);
    }

    private long getWaitLength(int permits, long now) {
        if (this.limiterData.getStoredPermits() >= (double)permits) {
            return 0L;
        }
        return TimeUnit.SECONDS.toMillis(Double.valueOf(((double)permits - this.getStoredPermits(now)) / this.limiterData.getPermitsPerSecond()).longValue());
    }

    private double getStoredPermits(long now) {
        return this.limiterData.getStoredPermits();
    }

    private void restore(long now) {
        long startRestoreMills = System.currentTimeMillis();
        String value = this.redisLockClient.get(this.newKey());
        now += System.currentTimeMillis() - startRestoreMills;
        if (!StringUtils.isEmpty((Object)value)) {
            this.debug(String.format("\u4ece redis \u6062\u590d \u6570\u636e, %s", value));
            this.limiterData = RateLimiterData.of(value, this.permitsPerSecond, this.maxPermits, this.key);
        } else {
            this.limiterData = RateLimiterData.of(this.permitsPerSecond, this.maxPermits, this.initStoredPermits, now);
            this.debug(String.format("\u7b2c\u4e00\u6b21\u521d\u59cb\u5316\u9650\u6d41\u5668, %s", this.limiterData.toString()));
        }
        this.limiterData.resync(now);
    }

    public static RedisRateLimiter create(String key, double permitsPerSecond) {
        return RedisRateLimiter.create(key, permitsPerSecond, 1.0, 1.0);
    }

    public static RedisRateLimiter create(String key, double permitsPerSecond, double maxBurstSeconds) {
        return RedisRateLimiter.create(key, permitsPerSecond, maxBurstSeconds, maxBurstSeconds);
    }

    public static RedisRateLimiter create(String key, double permitsPerSecond, double maxBurstSeconds, double initBurstSeconds) {
        Assert.isTrue((maxBurstSeconds > 0.0 ? 1 : 0) != 0, (String)"maxBurstSeconds \u5fc5\u987b\u5927\u4e8e0");
        RedisRateLimiter limiter = new RedisRateLimiter(permitsPerSecond, maxBurstSeconds * permitsPerSecond, initBurstSeconds * permitsPerSecond, key);
        limiter.redisLockClient = ((ILockWritable)((Object)RedisLockBuilder.builder(DATA_KEY_PREFIX).build())).getLockClient();
        return limiter;
    }

    private void debug(String message) {
        log.debug("RateLimiter:key={} {}", (Object)this.key, (Object)message);
    }
}

