/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis.concurrent;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RateLimiterData
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RateLimiterData.class);
    private double permitsPerSecond;
    private long nextFreeTicketMill;
    private double storedPermits;
    private double maxPermits;

    private RateLimiterData() {
    }

    public String toArrayString() {
        return String.format("%s,%s,%s,%s", this.permitsPerSecond, this.nextFreeTicketMill, this.storedPermits, this.maxPermits);
    }

    public static RateLimiterData of(String arrayString, double permitsPerSecond, double maxPermits, String key) {
        Objects.requireNonNull(arrayString);
        RateLimiterData data = new RateLimiterData();
        String[] strs = arrayString.split(",");
        Assert.isTrue((strs.length == 4 ? 1 : 0) != 0, (String)String.format("\u9700\u8981\u89e3\u6790\u7684rate limit \u5b57\u7b26\u4e32[%s] \u683c\u5f0f\u9519\u8bef", arrayString));
        data.permitsPerSecond = Double.valueOf(strs[0]);
        data.nextFreeTicketMill = Long.valueOf(strs[1]);
        data.storedPermits = Double.valueOf(strs[2]);
        data.maxPermits = Double.valueOf(strs[3]);
        StringBuilder overriedMessage = new StringBuilder();
        if (data.permitsPerSecond != permitsPerSecond) {
            overriedMessage.append(String.format("permitsPerSecond:[%s,%s],", permitsPerSecond, data.permitsPerSecond));
            data.permitsPerSecond = permitsPerSecond;
        }
        if (data.maxPermits != maxPermits) {
            overriedMessage.append(String.format("maxPermits:[%s:%s]", maxPermits, data.maxPermits));
            data.maxPermits = maxPermits;
        }
        if (overriedMessage.length() > 0) {
            log.error(String.format("RateLimiter[%s]\u914d\u7f6e\u53c2\u6570\u88ab\u91cd\u7f6e[\u65b0:\u65e7], %s", key, overriedMessage.toString()));
        }
        return data;
    }

    public static RateLimiterData of(double permitsPerSecond, double maxPermits, double initStoredPermits, long now) {
        RateLimiterData data = new RateLimiterData();
        data.permitsPerSecond = permitsPerSecond;
        data.nextFreeTicketMill = now;
        data.storedPermits = initStoredPermits;
        data.maxPermits = maxPermits;
        data.resync(now);
        return data;
    }

    public void acquire(double storedPermits, long nextFreeTicketMill) {
        this.storedPermits = Math.max(this.storedPermits - storedPermits, 0.0);
        this.nextFreeTicketMill = nextFreeTicketMill;
    }

    public void resync(long now) {
        if (now - this.nextFreeTicketMill < 0L) {
            return;
        }
        double storedPermits = this.storedPermits + (double)TimeUnit.MILLISECONDS.toSeconds(now - this.nextFreeTicketMill) * this.getPermitsPerSecond();
        this.storedPermits = Math.min(storedPermits, this.maxPermits);
    }

    public String toString() {
        return "RateLimiterData{permitsPerSecond=" + this.permitsPerSecond + ", nextFreeTicketMill=" + this.nextFreeTicketMill + ", storedPermits=" + this.storedPermits + ", maxPermits=" + this.maxPermits + '}';
    }

    public double getPermitsPerSecond() {
        return this.permitsPerSecond;
    }

    public long getNextFreeTicketMill() {
        return this.nextFreeTicketMill;
    }

    public double getStoredPermits() {
        return this.storedPermits;
    }

    public double getMaxPermits() {
        return this.maxPermits;
    }
}

