/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis;

import io.github.spring.tools.redis.IRedisLock;
import io.github.spring.tools.redis.RedisLockEnvironment;
import io.github.spring.tools.redis.decorator.AbsLockDecorator;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.util.CollectionUtils;

public class RedislockUtils {
    private static final Logger log = LoggerFactory.getLogger(RedislockUtils.class);
    private static final Comparator<Class<? extends AbsLockDecorator>> DECORATOR_COMPARETOR = Comparator.comparing(clazz -> {
        Integer order = OrderUtils.getOrder((Class)clazz);
        return order == null ? 1000 : order;
    });

    public static byte[] stringToBytes(String str) {
        try {
            return str == null ? null : str.getBytes(StandardCharsets.UTF_8);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static synchronized IRedisLock mergeEnv(IRedisLock sharedLock, Set<Class<? extends AbsLockDecorator>> classes, String keyPrefix) {
        Objects.requireNonNull(sharedLock);
        RedisLockEnvironment environment = RedisLockEnvironment.getInstance();
        environment.merge(sharedLock, keyPrefix);
        return RedislockUtils.doMergeDecoratorClasses(sharedLock, classes);
    }

    private static IRedisLock doMergeDecoratorClasses(IRedisLock sharedLock, Set<Class<? extends AbsLockDecorator>> classes) {
        Objects.requireNonNull(classes);
        RedisLockEnvironment environment = RedisLockEnvironment.getInstance();
        classes = new HashSet<Class<? extends AbsLockDecorator>>(classes);
        classes.addAll(environment.getBuilder().getDecorators());
        if (CollectionUtils.isEmpty(classes)) {
            return sharedLock;
        }
        ArrayList<Class<? extends AbsLockDecorator>> decoratorList = new ArrayList<Class<? extends AbsLockDecorator>>(classes);
        Collections.sort(decoratorList, DECORATOR_COMPARETOR);
        for (Class clazz : decoratorList) {
            try {
                sharedLock = (IRedisLock)clazz.getConstructor(IRedisLock.class).newInstance(sharedLock);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return sharedLock;
    }
}

