/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis;

import io.github.spring.tools.redis.IRedisLock;
import io.github.spring.tools.redis.RedisLockBuilder;
import io.github.spring.tools.redis.RedisLockStatus;
import io.github.spring.tools.redis.capable.ILockWritable;
import java.util.Objects;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StringUtils;

public class RedisLockEnvironment {
    private static RedisLockEnvironment INSTANCE;
    private RedisLockBuilder builder;
    private RedisTemplate<String, String> redisTemplate;

    RedisLockEnvironment(RedisTemplate<String, String> redisTemplate, RedisLockBuilder builder) {
        Objects.requireNonNull(redisTemplate);
        Objects.requireNonNull(builder);
        this.builder = builder;
        this.redisTemplate = redisTemplate;
        INSTANCE = this;
    }

    public static RedisLockEnvironment getInstance() {
        return INSTANCE;
    }

    public static RedisLockBuilder getBuilder() {
        Objects.requireNonNull(INSTANCE);
        return RedisLockEnvironment.INSTANCE.builder;
    }

    void merge(IRedisLock lock, String keyPrefix) {
        if (lock.getStatus() != RedisLockStatus.NEW) {
            throw new IllegalArgumentException(String.format("%s \u72b6\u6001\u7684\u9501\u4e0d\u53ef\u4ee5\u8bbe\u7f6e\u53c2\u6570", new Object[]{lock.getStatus()}));
        }
        ILockWritable writable = (ILockWritable)((Object)lock);
        if (!this.builder.isDefault(this.builder.getLockSeconds())) {
            writable.setLockSeconds(this.builder.getLockSeconds());
        }
        if (!this.builder.isDefault(this.builder.getSpinTimes())) {
            writable.setLockSeconds(this.builder.getSpinTimes());
        }
        if (!this.builder.isDefault(this.builder.getSleepMinMills())) {
            writable.setLockSeconds(this.builder.getSleepMinMills());
        }
        if (!this.builder.isDefault(this.builder.getSleepMaxMills())) {
            writable.setLockSeconds(this.builder.getSleepMaxMills());
        }
        if (!StringUtils.isEmpty((Object)this.builder.getKeyPrefix()) && StringUtils.isEmpty((Object)keyPrefix)) {
            writable.setKey(String.format("%s-%s", this.builder.getKeyPrefix(), lock.getKey()));
        }
    }

    public RedisTemplate<String, String> getRedisTemplate() {
        return this.redisTemplate;
    }
}

