/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis;

import io.github.spring.tools.redis.IRedisLock;
import io.github.spring.tools.redis.RedisLockClient;
import io.github.spring.tools.redis.RedisLockReleaseStatus;
import io.github.spring.tools.redis.RedisLockStatus;
import io.github.spring.tools.redis.capable.ILockWritable;
import io.github.spring.tools.redis.exception.UnLockFailException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StringUtils;

public class DefaultRedisLock
implements IRedisLock,
ILockWritable {
    private static final Logger log = LoggerFactory.getLogger(DefaultRedisLock.class);
    private RedisLockStatus status;
    private RedisLockReleaseStatus releaseStatus;
    private String key;
    private int lockSeconds;
    private int sleepMinMills;
    private int sleepMaxMills;
    private int spinTimes;
    private RedisLockClient redisLockClient;
    private String uuid;
    private RuntimeException throwableException;

    DefaultRedisLock(RedisTemplate<String, String> redisTemplate, String key, int lockSeconds, int sleepMinMills, int sleepMaxMills, int spinTimes, RuntimeException throwableException) {
        this.key = key;
        this.lockSeconds = lockSeconds;
        this.sleepMinMills = sleepMinMills;
        this.sleepMaxMills = sleepMaxMills;
        this.spinTimes = spinTimes;
        this.status = RedisLockStatus.NEW;
        this.redisLockClient = new RedisLockClient(redisTemplate);
        this.throwableException = throwableException;
    }

    @Override
    public boolean interrupted() {
        if (this.isStatus(RedisLockStatus.NEW)) {
            this.setStatus(RedisLockStatus.CANCEL);
            return true;
        }
        return false;
    }

    @Override
    public boolean needUnlock() {
        return this.getStatus() != RedisLockStatus.NEW;
    }

    @Override
    public RedisLockClient getLockClient() {
        return this.redisLockClient;
    }

    @Override
    public boolean tryLock() {
        if (this.doAcquire(this)) {
            this.setStatus(RedisLockStatus.LOCKED);
            this.setReleaseStatus(RedisLockReleaseStatus.NEW);
            this.debugMessage("\u83b7\u53d6\u9501\u6210\u529f");
            return true;
        }
        this.debugMessage("\u83b7\u53d6\u9501\u5931\u8d25");
        return false;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        Objects.requireNonNull(unit);
        if (this.getStatus() != RedisLockStatus.NEW) {
            throw new InterruptedException(String.format("%s \u9501\u7684\u5f53\u524d\u72b6\u6001\u662f %s \u4e0d\u80fd\u518d\u6b21\u83b7\u53d6\u9501", new Object[]{this.getKey(), this.getStatus()}));
        }
        try {
            if (this.doAcquire(time, unit)) {
                this.setStatus(RedisLockStatus.LOCKED);
                return true;
            }
            if (this.getStatus() == RedisLockStatus.NEW) {
                this.setStatus(RedisLockStatus.TIMEOUT);
            }
            return false;
        }
        catch (TimeoutException ex) {
            this.setStatus(RedisLockStatus.TIMEOUT);
            return false;
        }
    }

    @Override
    public void unlock() {
        block4: {
            try {
                if (this.doRelease(this)) {
                    this.unlocked(true);
                    this.debugMessage("\u89e3\u9501\u6210\u529f");
                } else {
                    this.debugMessage("\u89e3\u9501\u5931\u8d25");
                    this.unlocked(false);
                }
            }
            catch (UnLockFailException e) {
                this.unlocked(false);
                this.debugMessage("\u89e3\u9501\u5931\u8d25");
                if (this.throwableException == null) break block4;
                throw this.throwableException;
            }
        }
    }

    private boolean doAcquire(IRedisLock lock) {
        this.uuid = UUID.randomUUID().toString();
        return this.redisLockClient.setNx(lock.getKey(), this.uuid, lock.getLockSeconds());
    }

    private boolean doAcquire(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        long timeout = System.currentTimeMillis() + unit.toMillis(time);
        int timesCount = 0;
        while (true) {
            int times = this.getSpinTimes();
            while (true) {
                this.checkTimeout(timeout);
                if (this.tryLock()) {
                    this.debugMessage(String.format(" %s\u6b21\u83b7\u53d6\u6210\u529f\uff0c\u81ea\u65cb %s \u6b21", timesCount, this.getSpinTimes() - times + 1));
                    return true;
                }
                if (--times <= 0) break;
                this.debugMessage(String.format(" %s\u6b21\u83b7\u53d6\u5931\u8d25\uff0c\u81ea\u65cb %s \u6b21", ++timesCount, this.getSpinTimes() - times));
            }
            try {
                this.debugMessage(String.format(" %s\u6b21\u83b7\u53d6\u5931\u8d25\uff0c\u81ea\u65cb\u5931\u8d25\uff0c\u5f00\u59cb\u968f\u673a\u4f11\u7720", timesCount));
                Thread.sleep(this.getSleepMills());
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private void checkTimeout(long timeout) throws TimeoutException {
        if (System.currentTimeMillis() >= timeout) {
            throw new TimeoutException(this.getKey());
        }
    }

    private boolean doRelease(IRedisLock lock) throws UnLockFailException {
        if (StringUtils.isEmpty((Object)this.uuid)) {
            throw new IllegalArgumentException(String.format("redis \u5171\u4eab\u9501 %s provider data\u4e0d\u5b58\u5728", lock.getKey()));
        }
        if (this.redisLockClient.releaseByLua(this.key, this.uuid)) {
            return true;
        }
        if (this.uuid.equals(this.redisLockClient.get(this.key))) {
            return this.redisLockClient.delete(this.key);
        }
        return false;
    }

    protected void debugMessage(String message) {
        log.debug(String.format("%s --> %s \u9501 %s", this.getClass().getSimpleName(), this.getKey(), message));
    }

    @Override
    public RedisLockStatus getStatus() {
        return this.status;
    }

    @Override
    public RedisLockReleaseStatus getReleaseStatus() {
        return this.releaseStatus;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int getLockSeconds() {
        return this.lockSeconds;
    }

    @Override
    public int getSleepMinMills() {
        return this.sleepMinMills;
    }

    @Override
    public int getSleepMaxMills() {
        return this.sleepMaxMills;
    }

    @Override
    public int getSpinTimes() {
        return this.spinTimes;
    }

    public RedisLockClient getRedisLockClient() {
        return this.redisLockClient;
    }

    public String getUuid() {
        return this.uuid;
    }

    public RuntimeException getThrowableException() {
        return this.throwableException;
    }

    @Override
    public void setStatus(RedisLockStatus status) {
        this.status = status;
    }

    @Override
    public void setReleaseStatus(RedisLockReleaseStatus releaseStatus) {
        this.releaseStatus = releaseStatus;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void setLockSeconds(int lockSeconds) {
        this.lockSeconds = lockSeconds;
    }

    @Override
    public void setSleepMinMills(int sleepMinMills) {
        this.sleepMinMills = sleepMinMills;
    }

    @Override
    public void setSleepMaxMills(int sleepMaxMills) {
        this.sleepMaxMills = sleepMaxMills;
    }

    @Override
    public void setSpinTimes(int spinTimes) {
        this.spinTimes = spinTimes;
    }

    public void setRedisLockClient(RedisLockClient redisLockClient) {
        this.redisLockClient = redisLockClient;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setThrowableException(RuntimeException throwableException) {
        this.throwableException = throwableException;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRedisLock)) {
            return false;
        }
        DefaultRedisLock other = (DefaultRedisLock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RedisLockStatus this$status = this.getStatus();
        RedisLockStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        RedisLockReleaseStatus this$releaseStatus = this.getReleaseStatus();
        RedisLockReleaseStatus other$releaseStatus = other.getReleaseStatus();
        if (this$releaseStatus == null ? other$releaseStatus != null : !((Object)((Object)this$releaseStatus)).equals((Object)other$releaseStatus)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        if (this.getLockSeconds() != other.getLockSeconds()) {
            return false;
        }
        if (this.getSleepMinMills() != other.getSleepMinMills()) {
            return false;
        }
        if (this.getSleepMaxMills() != other.getSleepMaxMills()) {
            return false;
        }
        if (this.getSpinTimes() != other.getSpinTimes()) {
            return false;
        }
        RedisLockClient this$redisLockClient = this.getRedisLockClient();
        RedisLockClient other$redisLockClient = other.getRedisLockClient();
        if (this$redisLockClient == null ? other$redisLockClient != null : !this$redisLockClient.equals(other$redisLockClient)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        RuntimeException this$throwableException = this.getThrowableException();
        RuntimeException other$throwableException = other.getThrowableException();
        return !(this$throwableException == null ? other$throwableException != null : !this$throwableException.equals(other$throwableException));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultRedisLock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisLockStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        RedisLockReleaseStatus $releaseStatus = this.getReleaseStatus();
        result = result * 59 + ($releaseStatus == null ? 43 : ((Object)((Object)$releaseStatus)).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        result = result * 59 + this.getLockSeconds();
        result = result * 59 + this.getSleepMinMills();
        result = result * 59 + this.getSleepMaxMills();
        result = result * 59 + this.getSpinTimes();
        RedisLockClient $redisLockClient = this.getRedisLockClient();
        result = result * 59 + ($redisLockClient == null ? 43 : $redisLockClient.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        RuntimeException $throwableException = this.getThrowableException();
        result = result * 59 + ($throwableException == null ? 43 : $throwableException.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultRedisLock(status=" + (Object)((Object)this.getStatus()) + ", releaseStatus=" + (Object)((Object)this.getReleaseStatus()) + ", key=" + this.getKey() + ", lockSeconds=" + this.getLockSeconds() + ", sleepMinMills=" + this.getSleepMinMills() + ", sleepMaxMills=" + this.getSleepMaxMills() + ", spinTimes=" + this.getSpinTimes() + ", redisLockClient=" + this.getRedisLockClient() + ", uuid=" + this.getUuid() + ", throwableException=" + this.getThrowableException() + ")";
    }
}

