/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis.decorator;

import io.github.spring.tools.redis.IRedisLock;
import io.github.spring.tools.redis.RedisLockStatus;
import io.github.spring.tools.redis.decorator.AbsLockDecorator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=1000)
public class ReentrantLockDecorator
extends AbsLockDecorator {
    private static final Logger log = LoggerFactory.getLogger(ReentrantLockDecorator.class);
    private static final ThreadLocal<Map<String, ReentrantLockDecorator>> THREAD_LOCKS = new ThreadLocal<Map<String, ReentrantLockDecorator>>(){

        @Override
        protected Map<String, ReentrantLockDecorator> initialValue() {
            return new HashMap<String, ReentrantLockDecorator>(8);
        }
    };
    private RedisLockStatus currentStatus;
    private long getLockTime;

    public ReentrantLockDecorator(IRedisLock delegate) {
        super(delegate);
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(-1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        try {
            if (this.exisitsByThread()) {
                this.debugMessage("\u91cd\u7528\u9501\u6210\u529f");
                return true;
            }
            if (time == -1L ? this.delegate.tryLock() : this.delegate.tryLock(time, unit)) {
                this.debugMessage("\u83b7\u53d6\u65b0\u9501\u6210\u529f");
                this.setToThread();
                return true;
            }
        }
        catch (TimeoutException e) {
            this.currentStatus = RedisLockStatus.CANCEL;
            this.delegate.interrupted();
            this.debugMessage("\u9501\u83b7\u53d6\u5931\u8d25\u4e14\u53d6\u6d88\u6210\u529f");
        }
        return false;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    public void unlock() {
        if (this.clearFromThread()) {
            this.delegate.unlock();
            this.debugMessage("\u5f7b\u5e95\u91ca\u653e\u9501\u6210\u529f");
        } else {
            this.debugMessage("\u91ca\u653e\u9501\u6210\u529f");
        }
    }

    boolean exisitsByThread() throws TimeoutException {
        ReentrantLockDecorator lock = THREAD_LOCKS.get().get(this.getKey());
        if (lock == null) {
            return false;
        }
        if (System.currentTimeMillis() - lock.getLockTime > TimeUnit.MILLISECONDS.toMillis(lock.getLockSeconds())) {
            throw new TimeoutException(this.getKey());
        }
        return true;
    }

    @Override
    public RedisLockStatus getStatus() {
        return this.currentStatus == null ? super.getStatus() : this.currentStatus;
    }

    void setToThread() {
        this.getLockTime = System.currentTimeMillis();
        THREAD_LOCKS.get().put(this.getKey(), this);
    }

    boolean clearFromThread() {
        ReentrantLockDecorator lock = THREAD_LOCKS.get().get(this.getKey());
        if (lock != null && lock == this) {
            THREAD_LOCKS.get().remove(this.getKey());
            return true;
        }
        return false;
    }
}

