/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis.capable;

import io.github.spring.tools.redis.RedisLockReleaseStatus;
import io.github.spring.tools.redis.RedisLockStatus;

public interface ILockWritable {
    public static final int DEFAULT_SPIN_TIME = 3;
    public static final int DEFAULT_SLEEP_MIN_MILLS = 200;
    public static final int DEFAULT_SLEEP_MAX_MILLS = 500;
    public static final int DEFAULT_LOCK_SECONDS = 10;

    public void setStatus(RedisLockStatus var1);

    public void setKey(String var1);

    default public boolean isStatus(RedisLockStatus status) {
        return this.getStatus() == status;
    }

    public boolean needUnlock();

    public void setReleaseStatus(RedisLockReleaseStatus var1);

    public void setLockSeconds(int var1);

    public int getLockSeconds();

    public void setSleepMinMills(int var1);

    public int getSleepMinMills();

    public void setSleepMaxMills(int var1);

    public int getSleepMaxMills();

    public void setSpinTimes(int var1);

    public int getSpinTimes();

    public RedisLockStatus getStatus();

    default public int getSleepMills() {
        return this.getSleepMinMills() + (int)((double)(this.getSleepMaxMills() - this.getSleepMinMills()) * Math.random());
    }

    default public boolean inStates(RedisLockStatus ... statuses) {
        if (statuses == null) {
            return false;
        }
        for (RedisLockStatus status : statuses) {
            if (status != this.getStatus()) continue;
            return true;
        }
        return false;
    }

    default public void unlocked(boolean release) {
        this.setReleaseStatus(release ? RedisLockReleaseStatus.SUCCESS : RedisLockReleaseStatus.FAIL);
    }
}

