/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis.annotation.configuration;

import io.github.spring.tools.redis.RedisLockBuilder;
import io.github.spring.tools.redis.annotation.RedisLockInterceptor;
import io.github.spring.tools.redis.decorator.AbsLockDecorator;
import io.github.spring.tools.redis.decorator.ReentrantLockDecorator;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisLockConfiguration {
    @Autowired
    private RedisTemplate redisTemplate;

    @Bean
    public RedisLockInterceptor annotationSharedLoadInterceptor(ApplicationContext context) {
        return new RedisLockInterceptor((BeanFactory)context);
    }

    @PostConstruct
    public void initRedisLock() {
        RedisLockBuilder.builder("").keyPrefix("redis-lock").addDecorators(this.defaultDecorators()).buildEnv(this.redisTemplate);
    }

    private List<Class<? extends AbsLockDecorator>> defaultDecorators() {
        return Arrays.asList(ReentrantLockDecorator.class);
    }
}

