/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis.annotation;

import io.github.spring.tools.redis.IRedisLock;
import io.github.spring.tools.redis.RedisLockBuilder;
import io.github.spring.tools.redis.annotation.FaultPolicy;
import io.github.spring.tools.redis.annotation.RedisLock;
import io.github.spring.tools.redis.exception.NoopLockException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public final class AnnotationProcess {
    private BeanFactory beanFactory;
    private static final Object NOOP = new Object();

    @Autowired
    public AnnotationProcess(BeanFactory beanFactory) {
        Objects.requireNonNull(beanFactory);
        this.beanFactory = beanFactory;
    }

    public final Object handle(ProceedingJoinPoint jp) throws Throwable {
        MethodSignature signature = (MethodSignature)jp.getSignature();
        RedisLock shareLockAnnotation = signature.getMethod().getAnnotation(RedisLock.class);
        if (shareLockAnnotation == null) {
            return jp.proceed();
        }
        return this.lockExecute(jp, shareLockAnnotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lockExecute(ProceedingJoinPoint jp, RedisLock shareLockAnnotation) throws Throwable {
        Object rollbackData;
        Object processResultObject;
        MethodSignature signature = (MethodSignature)jp.getSignature();
        String[] parameterNames = signature.getParameterNames();
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        Object[] args = jp.getArgs();
        if (parameterNames != null && parameterNames.length > 0) {
            for (int i = 0; i < parameterNames.length; ++i) {
                params.put(parameterNames[i], args[i]);
            }
        }
        IRedisLock lockObject = this.buildLockObject(shareLockAnnotation, jp.getTarget(), signature.getMethod(), jp.getArgs(), params);
        try {
            boolean lockResult = shareLockAnnotation.waitTimeoutMills() <= 0 ? lockObject.tryLock() : lockObject.tryLock(shareLockAnnotation.waitTimeoutMills(), TimeUnit.MILLISECONDS);
            processResultObject = this.doExecute(lockObject, jp, shareLockAnnotation);
            if (lockResult) {
                processResultObject = jp.proceed();
            }
        }
        finally {
            lockObject.unlock();
        }
        if (lockObject.isRollback() && (rollbackData = this.rollback(jp, shareLockAnnotation, lockObject.getKey())) != NOOP) {
            processResultObject = rollbackData;
        }
        return processResultObject;
    }

    private Object doExecute(IRedisLock lock, ProceedingJoinPoint jp, RedisLock shareLockAnnotation) throws Throwable {
        FaultPolicy policy;
        MethodSignature signature = (MethodSignature)jp.getSignature();
        if (lock.isLocked()) {
            return jp.proceed();
        }
        FaultPolicy faultPolicy = policy = shareLockAnnotation.faultPolicy() == FaultPolicy.AUTO && !"__default".equals(shareLockAnnotation.fallbackMethod()) ? FaultPolicy.REPLACE : FaultPolicy.THROWABLE;
        if (policy == FaultPolicy.DO_NOTHING) {
            return this.faultDoNothing(signature, shareLockAnnotation);
        }
        if (policy == FaultPolicy.CONTINUE) {
            return jp.proceed();
        }
        if (policy == FaultPolicy.REPLACE) {
            return this.faultCallback(jp, shareLockAnnotation.fallbackMethod());
        }
        throw this.newThrowable(shareLockAnnotation.faultThrowableException(), lock.getKey());
    }

    private Object faultDoNothing(MethodSignature signature, RedisLock shareLockAnnotation) {
        return signature.getReturnType().isPrimitive() && Number.class.isAssignableFrom(signature.getReturnType()) ? Byte.valueOf((byte)-1) : null;
    }

    private Object faultCallback(ProceedingJoinPoint jp, String methodName) throws InvocationTargetException, IllegalAccessException {
        MethodSignature signature = (MethodSignature)jp.getSignature();
        if (StringUtils.isEmpty((Object)methodName)) {
            throw new UnsupportedOperationException(String.format("%s \u65b9\u6cd5\u7684SharedLock\u6ce8\u89e3\u672a\u5b9a\u4e49 faultMethod \u5c5e\u6027", signature.getMethod()));
        }
        try {
            Method method = jp.getTarget().getClass().getMethod(methodName, signature.getParameterTypes());
            if (!signature.getReturnType().isAssignableFrom(method.getReturnType())) {
                throw new UnsupportedOperationException(String.format("%s \u65b9\u6cd5\u7684SharedLock\u6ce8\u89e3\u5b9a\u4e49 faultMethod=%s \u65b9\u6cd5\u7b7e\u540d\u9519\u8bef", signature.getMethod(), methodName));
            }
            return method.invoke(jp.getTarget(), jp.getArgs());
        }
        catch (NoSuchMethodException ex) {
            throw new UnsupportedOperationException(String.format("%s \u65b9\u6cd5\u7684SharedLock\u6ce8\u89e3\u5b9a\u4e49 faultMethod=%s \u65b9\u6cd5\u7b7e\u540d\u9519\u8bef", signature.getMethod(), methodName));
        }
    }

    private Object rollback(ProceedingJoinPoint jp, RedisLock shareLockAnnotation, String key) throws Throwable {
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Method method = jp.getTarget().getClass().getMethod(shareLockAnnotation.rollbackMethod(), signature.getParameterTypes());
        if (method.getReturnType() != null && method.getReturnType().isAssignableFrom(((MethodSignature)jp.getSignature()).getReturnType())) {
            return method.invoke(jp.getTarget(), jp.getArgs());
        }
        if (shareLockAnnotation.rollbackThrowableException() != NoopLockException.class) {
            throw this.newThrowable(shareLockAnnotation.rollbackThrowableException(), key);
        }
        return NOOP;
    }

    private <T> T newThrowable(Class<T> clazz, String key) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        try {
            return clazz.getConstructor(String.class).newInstance(key);
        }
        catch (Exception e) {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    private IRedisLock buildLockObject(RedisLock lock, Object target, Method method, Object[] args, Map<String, Object> argMaps) {
        RedisLockBuilder builder = RedisLockBuilder.builder(this.buildKey(lock, target, method, argMaps));
        if (lock.lockedSeconds() != Integer.MAX_VALUE) {
            builder.lockSeconds(lock.lockedSeconds());
        }
        return builder.build();
    }

    private String buildKey(RedisLock lock, Object target, Method method, Map<String, Object> args) {
        String key;
        String string = key = StringUtils.isEmpty((Object)lock.key()) ? lock.value() : lock.key();
        if ("__default".equals(key)) {
            return method.toString();
        }
        return AnnotationProcess.parseKeyVariables(key, args);
    }

    private static String parseKeyVariables(String key, Map<String, Object> args) {
        if (args == null || args.isEmpty()) {
            return key;
        }
        for (Map.Entry<String, Object> arg : args.entrySet()) {
            key = key.replaceAll(String.format("\\#\\{%s\\}", arg.getKey()), arg.getValue() == null ? "" : arg.getValue().toString());
        }
        return key;
    }
}

