/*
 * Decompiled with CFR 0.152.
 */
package io.github.spring.tools.redis;

import io.github.spring.tools.redis.RedislockUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.Expiration;

public class RedisLockClient {
    private static final Logger log = LoggerFactory.getLogger(RedisLockClient.class);
    private static final String RELEASE_LUA;
    protected final RedisTemplate<String, String> redisTemplate;

    public RedisLockClient(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public <T> String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean setNx(String key, String value, int lockSeconds) {
        return (Boolean)this.redisTemplate.execute(connection -> {
            try {
                if (connection.set(RedislockUtils.stringToBytes(key), RedislockUtils.stringToBytes(value), Expiration.seconds((long)lockSeconds), RedisStringCommands.SetOption.SET_IF_ABSENT).booleanValue()) {
                    log.debug("spring data redis -> {} \u83b7\u53d6\u9501{}\u6570\u636e\u6210\u529f", (Object)key, (Object)value);
                    return true;
                }
            }
            catch (Exception e) {
                log.error("spring data redis -> {} \u9501\u83b7\u53d6\u8d85\u65f6", (Object)key, (Object)e);
            }
            return false;
        });
    }

    public boolean releaseByLua(String key, String value) {
        return (Boolean)this.redisTemplate.execute(connection -> {
            try {
                if (((Boolean)connection.eval(RedislockUtils.stringToBytes(RELEASE_LUA), ReturnType.BOOLEAN, 1, (byte[][])new byte[][]{RedislockUtils.stringToBytes(key), RedislockUtils.stringToBytes(value)})).booleanValue()) {
                    log.debug("spring data redis -> {} \u91ca\u653e\u9501\u6210\u529f", (Object)key);
                    return true;
                }
            }
            catch (Exception e) {
                log.error("spring data redis -> {} \u91ca\u653e\u9501\u8d85\u65f6", (Object)key, (Object)e);
            }
            return false;
        });
    }

    public <T> boolean delete(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("if redis.call(\"get\",KEYS[1]) == ARGV[1] ");
        sb.append("then ");
        sb.append("    return redis.call(\"del\",KEYS[1]) ");
        sb.append("else ");
        sb.append("    return 0 ");
        sb.append("end ");
        RELEASE_LUA = sb.toString();
    }
}

