/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators.scanner;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import eu.solven.cleanthat.engine.java.refactorer.meta.IConstructorNeedsJdkVersion;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.codehaus.plexus.languages.java.version.JavaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MutatorsScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutatorsScanner.class);
    private static final AtomicInteger ERROR_COUNTS = new AtomicInteger();
    private static final Set<Class<? extends IMutator>> SINGLE_MUTATORS;
    private static final Set<Class<? extends IMutator>> COMPOSITE_MUTATORS;

    private MutatorsScanner() {
    }

    @VisibleForTesting
    public static int getErrorCount() {
        return ERROR_COUNTS.get();
    }

    public static <T extends IMutator> List<T> instantiate(JavaVersion sourceJdkVersion, List<Class<? extends T>> classes) {
        return classes.stream().filter(Objects::nonNull).filter(IMutator.class::isAssignableFrom).map(c -> MutatorsScanner.instantiate(sourceJdkVersion, c)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T extends IMutator> T instantiate(JavaVersion sourceJdkVersion, Class<? extends T> mutatorClass) {
        try {
            if (IConstructorNeedsJdkVersion.class.isAssignableFrom(mutatorClass)) {
                return (T)((IMutator)mutatorClass.getConstructor(JavaVersion.class).newInstance(sourceJdkVersion));
            }
            return (T)((IMutator)mutatorClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            ERROR_COUNTS.incrementAndGet();
            LOGGER.error("Issue with {}", mutatorClass, (Object)e);
            return null;
        }
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"}, justification="The internal Set is immutable, so it is safe to expose it")
    public static Set<Class<? extends IMutator>> scanSingleMutators() {
        return SINGLE_MUTATORS;
    }

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"}, justification="The internal Set is immutable, so it is safe to expose it")
    public static Set<Class<? extends IMutator>> scanCompositeMutators() {
        return COMPOSITE_MUTATORS;
    }

    static {
        try {
            SINGLE_MUTATORS = Set.of(Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ArithmethicAssignment"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ArithmeticOverFloats"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ArraysDotStream"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.AvoidFileStream"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.AvoidInlineConditionals"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.AvoidMultipleUnaryOperators"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.AvoidUncheckedExceptionsInSignatures"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.CastMathOperandsBeforeAssignement"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.CollectionIndexOfToContains"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.CollectionToOptional"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ComparisonWithNaN"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.CreateTempFilesUsingNio"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.EmptyControlStatement"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.EnumsWithoutEquals"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ForEachAddToStreamCollectToCollection"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ForEachIfBreakElseToStreamTakeWhile"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ForEachIfBreakToStreamFindFirst"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ForEachIfToIfStreamAnyMatch"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ForEachToIterableForEach"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.GuavaImmutableMapBuilderOverVarargs"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.GuavaInlineStringsRepeat"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.GuavaStringsIsNullOrEmpty"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ImportQualifiedTokens"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.JUnit4ToJUnit5"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaIsMethodReference"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaReturnsSingleStatement"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.LiteralsFirstInComparisons"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.LocalVariableTypeInference"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.LoopIntRangeToIntStreamForEach"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ModifierOrder"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.NullCheckToOptionalOfNullable"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ObjectEqualsForPrimitives"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ObjectsHashCodePrimitive"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.OptionalMapIdentity"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.OptionalNotEmpty"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.OptionalWrappedIfToFilter"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.OptionalWrappedVariableToMap"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.PrimitiveWrapperInstantiation"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.RedundantLogicalComplementsInStream"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.RemoveAllToClearCollection"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.RemoveExplicitCallToSuper"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.SimplifyBooleanExpression"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.SimplifyBooleanInitialization"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.SimplifyStartsWith"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.StreamAnyMatch"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.StreamFlatMapStreamToFlatMap"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.StreamForEachNestingForLoopToFlatMap"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.StreamMapIdentity"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.StreamWrappedIfToFilter"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.StreamWrappedMethodRefToMap"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.StreamWrappedVariableToMap"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.StringFromString"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.StringIndexOfToContains"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.StringReplaceAllWithQuotableInput"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.StringToString"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.ThreadRunToThreadStart"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UnnecessaryBoxing"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UnnecessaryFullyQualifiedName"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UnnecessaryImport"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UnnecessaryLambdaEnclosingParameters"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UnnecessaryModifier"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UnnecessarySemicolon"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UseCollectionIsEmpty"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UseDiamondOperator"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UseDiamondOperatorJdk8"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UseIndexOfChar"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UsePredefinedStandardCharset"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UseStringIsEmpty"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UseTextBlocks"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.UseUnderscoresInNumericLiterals"));
        }
        catch (ClassNotFoundException e) {
            ERROR_COUNTS.incrementAndGet();
            throw new IllegalStateException("Cannot load CleanThat mutators", e);
        }
        try {
            COMPOSITE_MUTATORS = Set.of(Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.CompositeWalkingMutator"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.CheckStyleMutators"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.ErrorProneMutators"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.GuavaMutators"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.JSparrowMutators"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.PMDMutators"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.SafeAndConsensualMutators"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.SafeButControversialMutators"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.SafeButNotConsensualMutators"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.SonarMutators"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.SpotBugsMutators"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.StreamMutators"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.UnsafeDueToGenerics"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.AllIncludingDraftCompositeMutators"), Class.forName("eu.solven.cleanthat.engine.java.refactorer.mutators.composite.AllIncludingDraftSingleMutators"));
        }
        catch (ClassNotFoundException e) {
            ERROR_COUNTS.incrementAndGet();
            throw new IllegalStateException("Cannot load CleanThat mutators", e);
        }
    }
}

