/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import java.util.Optional;
import java.util.Set;

public class UnnecessarySemicolon
extends AJavaparserNodeMutator {
    public String minimalJavaVersion() {
        return "1";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"ExplicitToImplicit");
    }

    public Set<String> getPmdIds() {
        return ImmutableSet.of((Object)"ExplicitToImplicit");
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_codestyle.html#unnecessarysemicolon";
    }

    public Optional<String> getPmdId() {
        return Optional.of("UnnecessarySemicolon");
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-2959");
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> node) {
        if (node.getNode() instanceof Statement) {
            Statement stmt = (Statement)node.getNode();
            return this.processNotRecursively(stmt);
        }
        return false;
    }

    protected boolean processNotRecursively(Statement stmt) {
        Expression condition;
        IfStmt ifStmt;
        if (!stmt.isEmptyStmt()) {
            return false;
        }
        EmptyStmt emptyStmt = stmt.asEmptyStmt();
        Optional parentNode = emptyStmt.getParentNode();
        if (parentNode.isPresent() && parentNode.get() instanceof IfStmt && (ifStmt = (IfStmt)parentNode.get()).getThenStmt().equals((Object)emptyStmt) && ifStmt.getElseStmt().isEmpty() && (condition = ifStmt.getCondition()).isMethodCallExpr()) {
            return this.tryReplace((Node)ifStmt, (Node)new ExpressionStmt(condition));
        }
        return stmt.remove();
    }
}

