/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.JavaToken;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.javadoc.description.JavadocDescription;
import com.github.javaparser.javadoc.description.JavadocInlineTag;
import com.github.javaparser.javadoc.description.JavadocSnippet;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class UnnecessaryImport
extends AJavaparserNodeMutator {
    public String minimalJavaVersion() {
        return "1";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"ExplicitToImplicit", (Object)"Import");
    }

    public Set<String> getPmdIds() {
        return ImmutableSet.of((Object)"UnnecessaryImport", (Object)"UnusedImports");
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_codestyle.html#unnecessaryimport";
    }

    public Optional<String> getCheckstyleId() {
        return Optional.of("UnusedImports");
    }

    public String checkstyleUrl() {
        return "https://checkstyle.sourceforge.io/config_imports.html#UnusedImports";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-2208");
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> node) {
        if (!(node.getNode() instanceof CompilationUnit)) {
            return false;
        }
        CompilationUnit compilationUnit = (CompilationUnit)node.getNode();
        NodeList importDeclarations = compilationUnit.getImports();
        if (importDeclarations.isEmpty()) {
            return false;
        }
        Set<String> tokensInUse = UnnecessaryImport.tokensInUse(compilationUnit);
        ArrayList<ImportDeclaration> unnecessaryImports = new ArrayList<ImportDeclaration>();
        unnecessaryImports.addAll(UnnecessaryImport.unusedImports((Collection<ImportDeclaration>)importDeclarations, tokensInUse));
        unnecessaryImports.addAll(UnnecessaryImport.samePackageImports((Collection<ImportDeclaration>)importDeclarations, compilationUnit.getPackageDeclaration()));
        if (unnecessaryImports.isEmpty()) {
            return false;
        }
        unnecessaryImports.forEach(importDeclaration -> {
            try {
                importDeclaration.remove();
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Issue removing an import statement: " + importDeclaration, e);
            }
        });
        return true;
    }

    private static Set<String> tokensInUse(CompilationUnit unit) {
        Stream<Object> packageDecl = unit.getPackageDeclaration().isPresent() ? Stream.of((PackageDeclaration)unit.getPackageDeclaration().get()).map(PackageDeclaration::getAnnotations).flatMap(Collection::stream) : Stream.empty();
        Stream<String> typesInCode = Stream.concat(packageDecl, unit.getTypes().stream()).map(Node::getTokenRange).filter(Optional::isPresent).map(Optional::get).filter(r -> r != TokenRange.INVALID).flatMap(r -> StreamSupport.stream(r.spliterator(), false)).map(JavaToken::asString);
        Stream typesInJavadocs = unit.getAllComments().stream().filter(JavadocComment.class::isInstance).map(JavadocComment.class::cast).map(JavadocComment::parse).flatMap(UnnecessaryImport::parseJavadoc);
        return Stream.concat(typesInCode, typesInJavadocs).filter(t -> t != null && !t.isEmpty() && Character.isJavaIdentifierStart(t.charAt(0))).collect(Collectors.toSet());
    }

    private static List<ImportDeclaration> unusedImports(Collection<ImportDeclaration> imports, Set<String> tokensInUse) {
        return imports.stream().filter(i -> {
            if (i.isAsterisk()) {
                return false;
            }
            String[] segments = i.getNameAsString().split("[.]");
            if (segments.length == 0) {
                throw new AssertionError((Object)"Parse tree includes invalid import statements");
            }
            String lastSegment = segments[segments.length - 1];
            return !tokensInUse.contains(lastSegment);
        }).collect(Collectors.toList());
    }

    static List<ImportDeclaration> samePackageImports(Collection<ImportDeclaration> imports, Optional<PackageDeclaration> packageDeclaration) {
        String packageName = packageDeclaration.map(p -> p.getName().toString()).orElse("");
        return imports.stream().filter(i -> {
            String imported = i.getNameAsString();
            if (packageName.isEmpty()) {
                return !imported.contains(".");
            }
            if (i.isAsterisk()) {
                return imported.equals(packageName);
            }
            if (!imported.startsWith(packageName)) {
                return false;
            }
            return imported.lastIndexOf(46) == packageName.length();
        }).collect(Collectors.toList());
    }

    private static Stream<String> parseJavadoc(Javadoc javadoc) {
        Stream stringsFromJavadocDescription = Stream.of(javadoc.getDescription()).flatMap(UnnecessaryImport::parseJavadocDescription);
        Stream stringsFromBlockTags = javadoc.getBlockTags().stream().flatMap(tag -> {
            EnumSet<JavadocBlockTag.Type> blockTagTypesWithImportableNames = EnumSet.of(JavadocBlockTag.Type.THROWS, JavadocBlockTag.Type.EXCEPTION);
            Stream<Object> importableTagNames = blockTagTypesWithImportableNames.contains(tag.getType()) ? Stream.of(tag.getName()).filter(Optional::isPresent).map(Optional::get) : Stream.empty();
            Stream tagDescriptions = Stream.of(tag.getContent()).flatMap(UnnecessaryImport::parseJavadocDescription);
            return Stream.concat(importableTagNames, tagDescriptions);
        });
        return Stream.concat(stringsFromJavadocDescription, stringsFromBlockTags);
    }

    private static Stream<String> parseJavadocDescription(JavadocDescription description) {
        return description.getElements().stream().map(element -> {
            if (element instanceof JavadocInlineTag) {
                return ((JavadocInlineTag)element).getContent();
            }
            if (element instanceof JavadocSnippet) {
                return element.toText();
            }
            return element.toText();
        }).flatMap(s -> Stream.of(s.split("\\W+")));
    }
}

