/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyAfterMe;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaReturnsSingleStatement;
import eu.solven.cleanthat.engine.java.refactorer.mutators.OptionalWrappedVariableToMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

@ApplyAfterMe(value={LambdaReturnsSingleStatement.class})
public class StreamWrappedVariableToMap
extends OptionalWrappedVariableToMap {
    private static final String METHOD_MAP = "map";
    private static final String METHOD_MAP_TO_INT = "mapToInt";
    private static final String METHOD_MAP_TO_LNG = "mapToLong";
    private static final String METHOD_MAP_TO_DBL = "mapToDouble";
    private static final Set<String> SIMPLIFIED_TO_MAP = Set.of("mapToInt", "mapToLong", "mapToDouble");

    @Override
    public String minimalJavaVersion() {
        return "1.8";
    }

    @Override
    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Primitive", (Object)"Loop", (Object)"Stream");
    }

    public Set<String> getLegacyIds() {
        return Set.of("SimplifyStreamVariablesWithMap");
    }

    @Override
    protected Set<String> getEligibleForUnwrappedMap() {
        return Set.of("forEach", METHOD_MAP, METHOD_MAP_TO_INT, METHOD_MAP_TO_LNG, METHOD_MAP_TO_DBL);
    }

    @Override
    protected Class<?> getExpectedScope() {
        return BaseStream.class;
    }

    @Override
    protected Optional<String> computeMapMethodName(NodeAndSymbolSolver<? extends Expression> expression, Type type) {
        assert (MethodCallExprHelpers.scopeHasRequiredType(expression, BaseStream.class));
        if (type.isPrimitiveType()) {
            PrimitiveType.Primitive primitiveType = type.asPrimitiveType().getType();
            if (MethodCallExprHelpers.scopeHasRequiredType(expression, IntStream.class) && primitiveType == PrimitiveType.Primitive.INT || MethodCallExprHelpers.scopeHasRequiredType(expression, LongStream.class) && primitiveType == PrimitiveType.Primitive.LONG || MethodCallExprHelpers.scopeHasRequiredType(expression, DoubleStream.class) && primitiveType == PrimitiveType.Primitive.DOUBLE) {
                return Optional.of(METHOD_MAP);
            }
            if (primitiveType == PrimitiveType.Primitive.INT) {
                return Optional.of(METHOD_MAP_TO_INT);
            }
            if (primitiveType == PrimitiveType.Primitive.LONG) {
                return Optional.of(METHOD_MAP_TO_LNG);
            }
            if (primitiveType == PrimitiveType.Primitive.DOUBLE) {
                return Optional.of(METHOD_MAP_TO_DBL);
            }
        } else if (MethodCallExprHelpers.scopeHasRequiredType(expression, Object.class)) {
            if (MethodCallExprHelpers.scopeHasRequiredType(expression, Stream.class)) {
                return Optional.of(METHOD_MAP);
            }
            return Optional.of("mapToObj");
        }
        return Optional.empty();
    }

    @Override
    protected void adjustMethodName(MethodCallExpr methodCallExpr) {
        if (SIMPLIFIED_TO_MAP.contains(methodCallExpr.getNameAsString())) {
            methodCallExpr.setName(METHOD_MAP);
        }
    }
}

