/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.LambdaExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyAfterMe;
import eu.solven.cleanthat.engine.java.refactorer.meta.IReApplyUntilNoop;
import eu.solven.cleanthat.engine.java.refactorer.meta.RepeatOnSuccess;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaIsMethodReference;
import eu.solven.cleanthat.engine.java.refactorer.mutators.StreamMutatorHelpers;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplyAfterMe(value={LambdaIsMethodReference.class})
@RepeatOnSuccess
public class StreamForEachNestingForLoopToFlatMap
extends AJavaparserExprMutator
implements IReApplyUntilNoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamForEachNestingForLoopToFlatMap.class);
    private static final Map<Class<?>, String> TYPE_TO_FLATMAP = Map.of(Stream.class, "flatMap", IntStream.class, "flatMapToInt", LongStream.class, "flatMapToLong", DoubleStream.class, "flatMapToDouble");

    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Stream", (Object)"Loop");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("FlatMapInsteadOfNestedLoops");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/flat-map-instead-of-nested-loops.html";
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        Optional<String> flatMapMethod;
        Expression flatMapExpression;
        Expression ensureStream;
        Optional<MethodCallExpr> optMethodCall = MethodCallExprHelpers.match(expr, Object.class, "forEach", e -> e.isLambdaExpr());
        if (optMethodCall.isEmpty()) {
            return false;
        }
        MethodCallExpr callForEach = optMethodCall.get();
        if (MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(callForEach.getScope()), Stream.class)) {
            ensureStream = (Expression)callForEach.getScope().get();
        } else if (MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(callForEach.getScope()), Collection.class)) {
            ensureStream = new MethodCallExpr((Expression)callForEach.getScope().get(), "stream");
        } else {
            return false;
        }
        LambdaExpr forEachLambdaExpr = callForEach.getArgument(0).asLambdaExpr();
        Optional<MethodCallExpr> optSingleMethodCall = StreamMutatorHelpers.findSingleMethodCallExpr(forEachLambdaExpr.getBody());
        if (optSingleMethodCall.isEmpty()) {
            return false;
        }
        MethodCallExpr singleMethodCall = optSingleMethodCall.get();
        if (!"forEach".equals(singleMethodCall.getNameAsString())) {
            return false;
        }
        Expression rawFlatMapExpression = (Expression)singleMethodCall.getScope().get();
        if (MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(rawFlatMapExpression), Collection.class)) {
            flatMapExpression = new MethodCallExpr(rawFlatMapExpression.clone(), "stream");
            flatMapMethod = Optional.of("flatMap");
        } else {
            LOGGER.debug("We are flattening into something like `.flatMap(s -> s)`");
            flatMapExpression = rawFlatMapExpression;
            flatMapMethod = TYPE_TO_FLATMAP.entrySet().stream().filter(e -> MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(rawFlatMapExpression), (Class)e.getKey())).map(Map.Entry::getValue).findAny();
        }
        if (flatMapMethod.isEmpty()) {
            return false;
        }
        Optional<LambdaExpr> flatMapLambdaExpr = LambdaExprHelpers.makeLambdaExpr(forEachLambdaExpr.getParameter(0).getName(), flatMapExpression);
        if (flatMapLambdaExpr.isEmpty()) {
            return false;
        }
        MethodCallExpr callFlatMap = new MethodCallExpr(ensureStream, flatMapMethod.get(), new NodeList((Node[])new Expression[]{(Expression)flatMapLambdaExpr.get()}));
        MethodCallExpr callInnerForEach = new MethodCallExpr((Expression)callFlatMap, "forEach", singleMethodCall.getArguments());
        return this.tryReplace((Node)callForEach, (Node)callInnerForEach);
    }
}

