/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;

public class RemoveAllToClearCollection
extends AJavaparserExprMutator {
    public String minimalJavaVersion() {
        return "1.2";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Collection");
    }

    public Optional<String> getSpotBugsId() {
        return Optional.of("DMI_USING_REMOVEALL_TO_CLEAR_COLLECTION");
    }

    public String spotBugsUrl() {
        return "https://spotbugs.readthedocs.io/en/stable/bugDescriptions.html#dmi-using-removeall-to-clear-collection";
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCall = expr.getNode().asMethodCallExpr();
        if (!"removeAll".equals(methodCall.getNameAsString())) {
            return false;
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(methodCall.getScope()), Collection.class)) {
            return false;
        }
        if (methodCall.getArguments().size() != 1) {
            return false;
        }
        if (this.isMethodReturnUsed(methodCall)) {
            return false;
        }
        Expression scope = (Expression)methodCall.getScope().get();
        if (!scope.equals((Object)methodCall.getArgument(0))) {
            return false;
        }
        return this.tryReplace((Node)methodCall, (Node)new MethodCallExpr(scope, "clear"));
    }
}

