/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyBeforeMe;
import eu.solven.cleanthat.engine.java.refactorer.mutators.UnnecessaryModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplyBeforeMe(value={UnnecessaryModifier.class})
public class ModifierOrder
extends AJavaparserNodeMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModifierOrder.class);
    private static final List<String> ORDERED_MODIFIERS = ImmutableList.of((Object)"public", (Object)"protected", (Object)"private", (Object)"abstract", (Object)"default", (Object)"static", (Object)"sealed", (Object)"non-sealed", (Object)"final", (Object)"transient", (Object)"volatile", (Object)"synchronized", (Object[])new String[]{"native", "strictfp"});

    public boolean isDraft() {
        return false;
    }

    public String minimalJavaVersion() {
        return "1";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Convention");
    }

    public Optional<String> getCheckstyleId() {
        return Optional.of("ModifierOrder");
    }

    public String checkstyleUrl() {
        return "https://checkstyle.sourceforge.io/apidocs/com/puppycrawl/tools/checkstyle/checks/modifier/ModifierOrderCheck.html";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-1124");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("ReorderModifiers");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/reorder-modifiers.html";
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> nodeAndContext) {
        Object node = nodeAndContext.getNode();
        if (node instanceof NodeWithModifiers) {
            NodeWithModifiers nodeWithModifiers = (NodeWithModifiers)node;
            NodeList modifiers = nodeWithModifiers.getModifiers();
            ArrayList<Modifier> mutableModifiers = new ArrayList<Modifier>((Collection<Modifier>)modifiers);
            Collections.sort(mutableModifiers, this.modifiersComparator());
            boolean changed = this.areSameReferences((List<Modifier>)modifiers, mutableModifiers);
            if (changed) {
                return this.applyModifiers(nodeWithModifiers, (NodeList<Modifier>)modifiers, mutableModifiers);
            }
        }
        return false;
    }

    private Comparator<Modifier> modifiersComparator() {
        return new Comparator<Modifier>(){

            @Override
            public int compare(Modifier o1, Modifier o2) {
                return this.compare2(o1.getKeyword().asString(), o2.getKeyword().asString());
            }

            private int compare2(String left, String right) {
                return Integer.compare(ORDERED_MODIFIERS.indexOf(left), ORDERED_MODIFIERS.indexOf(right));
            }
        };
    }

    private boolean applyModifiers(NodeWithModifiers<?> nodeWithModifiers, NodeList<Modifier> originalModifiers, List<Modifier> sortedModifiers) {
        if (sortedModifiers.stream().map(m -> m.getKeyword()).anyMatch(m -> m == Modifier.Keyword.SEALED || m == Modifier.Keyword.NON_SEALED)) {
            LOGGER.warn("We do not re-order {} into {} due to {}", new Object[]{originalModifiers, sortedModifiers, "https://github.com/javaparser/javaparser/issues/4245"});
            return false;
        }
        nodeWithModifiers.setModifiers(new Modifier.Keyword[0]);
        LOGGER.debug("We fixed the ordering of modifiers");
        NodeList asNodeList = new NodeList(sortedModifiers);
        nodeWithModifiers.setModifiers(asNodeList);
        return true;
    }

    private boolean areSameReferences(List<Modifier> modifiers, List<Modifier> mutableModifiers) {
        if (modifiers.size() != mutableModifiers.size()) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < modifiers.size(); ++i) {
            if (modifiers.get(i) == mutableModifiers.get(i)) continue;
            changed = true;
            break;
        }
        return changed;
    }
}

