/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedAnnotationDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.IDisabledMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ImportDeclarationHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnit4ToJUnit5
extends AJavaparserNodeMutator
implements IDisabledMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnit4ToJUnit5.class);
    private final Map<String, String> fromTo = ImmutableMap.builder().put((Object)"org.junit.Before", (Object)"org.junit.jupiter.api.BeforeEach").put((Object)"org.junit.After", (Object)"org.junit.jupiter.api.AfterEach").put((Object)"org.junit.BeforeClass", (Object)"org.junit.jupiter.api.BeforeAll").put((Object)"org.junit.AfterClass", (Object)"org.junit.jupiter.api.AfterAll").put((Object)"org.junit.Ignore", (Object)"org.junit.jupiter.api.Disabled").put((Object)"org.junit.Assert", (Object)"org.junit.jupiter.api.Assertions").put((Object)"org.junit.Test", (Object)"org.junit.jupiter.api.Test").build();

    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"JUnit");
    }

    public String getId() {
        return "JUnit4ToJupiter";
    }

    public boolean isJreOnly() {
        return false;
    }

    public boolean walkAstHasChanged(Node tree) {
        AtomicBoolean transformed = new AtomicBoolean(false);
        if (super.walkAstHasChanged((Object)tree)) {
            transformed.set(true);
        }
        if (tree instanceof CompilationUnit) {
            CompilationUnit compilationUnit = (CompilationUnit)tree;
            compilationUnit.getImports().forEach(importNode -> {
                String importName = importNode.getName().asString();
                Optional<String> optMigratedName = this.computeNewName(importName);
                if (optMigratedName.isPresent()) {
                    importNode.setName(optMigratedName.get());
                    transformed.set(true);
                }
            });
        }
        return transformed.get();
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> node) {
        boolean localTransformed = false;
        if (node.getNode() instanceof AnnotationExpr) {
            localTransformed = this.processAnnotation(node.editNode((AnnotationExpr)node.getNode()));
        } else if (node.getNode() instanceof MethodCallExpr) {
            localTransformed = this.processMethodCall(node.editNode((MethodCallExpr)node.getNode()));
        }
        return localTransformed;
    }

    private Optional<String> computeNewName(String importName) {
        Optional<String> optMigratedName = "org.junit".equals(importName) ? Optional.of("org.junit.jupiter.api") : Optional.ofNullable(this.fromTo.get(importName));
        return optMigratedName;
    }

    protected boolean processAnnotation(NodeAndSymbolSolver<? extends AnnotationExpr> annotation) {
        ResolvedAnnotationDeclaration resolvedAnnotation;
        try {
            resolvedAnnotation = (ResolvedAnnotationDeclaration)annotation.getSymbolResolver().resolveDeclaration((Node)annotation.getNode(), ResolvedAnnotationDeclaration.class);
        }
        catch (UnsolvedSymbolException e) {
            LOGGER.debug("We were not able to resolve annotation: {}", annotation);
            return false;
        }
        String qualifiedName = resolvedAnnotation.getQualifiedName();
        Optional<String> optMigratedName = this.computeNewName(qualifiedName);
        boolean localTransformed = false;
        if (optMigratedName.isPresent()) {
            int lastDot;
            String currentName;
            String migratedName = optMigratedName.get();
            String newName = (currentName = annotation.getNode().getNameAsString()).indexOf(46) >= 0 ? migratedName : ((lastDot = migratedName.lastIndexOf(46)) < 0 ? migratedName : migratedName.substring(lastDot + 1));
            if (!currentName.equals(newName)) {
                localTransformed = true;
                annotation.getNode().setName(migratedName);
            }
        }
        return localTransformed;
    }

    private boolean processMethodCall(NodeAndSymbolSolver<MethodCallExpr> nodeAndSymbolSolver) {
        ResolvedReferenceType referenceType;
        String oldQualifiedName;
        Optional<String> optNewName;
        MethodCallExpr node = nodeAndSymbolSolver.getNode();
        Optional optScope = node.getScope();
        if (optScope.isEmpty()) {
            return false;
        }
        Expression scope = (Expression)optScope.get();
        Optional<ResolvedType> type = MethodCallExprHelpers.optResolvedType(nodeAndSymbolSolver.editNode(scope));
        if (type.isPresent() && type.get().isReferenceType() && (optNewName = this.computeNewName(oldQualifiedName = (referenceType = type.get().asReferenceType()).getQualifiedName())).isPresent()) {
            NameExpr newScope;
            String newQualifiedName = optNewName.get();
            boolean imported = ImportDeclarationHelpers.isImported(nodeAndSymbolSolver, new ImportDeclaration(newQualifiedName, false, false));
            if (imported) {
                String newSimpleName = newQualifiedName.substring(newQualifiedName.lastIndexOf(46) + 1);
                newScope = new NameExpr(newSimpleName);
            } else {
                newScope = new NameExpr(newQualifiedName);
            }
            MethodCallExpr replacement = new MethodCallExpr((Expression)newScope, node.getNameAsString(), node.getArguments());
            return this.tryReplace(nodeAndSymbolSolver, (Node)replacement);
        }
        return false;
    }
}

