/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.helpers;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import java.util.Objects;
import java.util.Optional;

public class ImportDeclarationHelpers {
    private static final String JAVA_LANG = "java.lang";

    protected ImportDeclarationHelpers() {
    }

    public static boolean isImported(NodeAndSymbolSolver<?> compilationUnit, String methodRefPackage, String qualifiedName) {
        String packageDecl;
        Optional<PackageDeclaration> optPackageDeclaration = compilationUnit.getPackageDeclaration();
        if (optPackageDeclaration.isPresent() && methodRefPackage.equals(packageDecl = optPackageDeclaration.get().getNameAsString())) {
            return true;
        }
        NodeList<ImportDeclaration> imports = compilationUnit.getImports();
        if (imports.isEmpty() && methodRefPackage.indexOf(46) >= 0) {
            return false;
        }
        if (JAVA_LANG.equals(methodRefPackage)) {
            return true;
        }
        return imports.stream().anyMatch(id -> id.getNameAsString().equals(qualifiedName));
    }

    public static String getStaticMethodClassRefMayAddImport(NodeAndSymbolSolver<?> node, Class<?> clazz) {
        String methodRefClassName;
        String qualifiedName = clazz.getName();
        String classSimpleName = clazz.getSimpleName();
        if (ImportDeclarationHelpers.isImported(node, clazz.getPackageName(), qualifiedName)) {
            methodRefClassName = classSimpleName;
        } else if (ImportDeclarationHelpers.isImportable(node, qualifiedName)) {
            node.addImport(qualifiedName, false, false);
            methodRefClassName = classSimpleName;
        } else {
            methodRefClassName = qualifiedName;
        }
        return methodRefClassName;
    }

    protected static String getSimpleName(String qualifiedName) {
        int indexOfDot = qualifiedName.lastIndexOf(46);
        if (indexOfDot < 0) {
            return qualifiedName;
        }
        return qualifiedName.substring(indexOfDot + 1);
    }

    public static boolean isImportable(NodeAndSymbolSolver<?> context, String qualifiedName) {
        NodeList<ImportDeclaration> imports = context.getImports();
        String tokenName = ImportDeclarationHelpers.getSimpleName(qualifiedName);
        return imports.stream().noneMatch(id -> id.isAsterisk() || ImportDeclarationHelpers.getSimpleName(id.getNameAsString()).equals(tokenName));
    }

    public static NameExpr nameOrQualifiedName(NodeAndSymbolSolver<?> compilationUnit, Class<?> clazz) {
        return new NameExpr(ImportDeclarationHelpers.nameOrQualifiedNameAsString(compilationUnit, clazz));
    }

    private static String nameOrQualifiedNameAsString(NodeAndSymbolSolver<?> compilationUnit, Class<?> clazz) {
        if (ImportDeclarationHelpers.isImported(compilationUnit, clazz.getPackageName(), clazz.getName())) {
            return clazz.getSimpleName();
        }
        return clazz.getName();
    }

    public static boolean isImported(NodeAndSymbolSolver<? extends Expression> expr, String imported) {
        Optional optCompilationUnit = expr.getNode().findCompilationUnit();
        if (optCompilationUnit.isEmpty()) {
            return false;
        }
        return ((CompilationUnit)optCompilationUnit.get()).getImports().stream().anyMatch(importDecl -> !importDecl.isAsterisk() && !importDecl.isStatic() && imported.equals(importDecl.getNameAsString()));
    }

    public static boolean isImported(NodeAndSymbolSolver<? extends Expression> context, ImportDeclaration importDeclaration) {
        return !ImportDeclarationHelpers.isImplicitImport(context, importDeclaration) && context.getImports().stream().noneMatch(im -> im.equals((Object)importDeclaration) || im.isAsterisk() && Objects.equals(ImportDeclarationHelpers.getImportPackageName(im).get(), ImportDeclarationHelpers.getImportPackageName(importDeclaration).orElse(null)));
    }

    private static boolean isImplicitImport(NodeAndSymbolSolver<? extends Expression> context, ImportDeclaration importDeclaration) {
        Optional<Name> importPackageName = ImportDeclarationHelpers.getImportPackageName(importDeclaration);
        if (importPackageName.isPresent()) {
            if (StaticJavaParser.parseName((String)JAVA_LANG).equals((Object)importPackageName.get())) {
                return true;
            }
            if (context.getPackageDeclaration().isPresent()) {
                Name currentPackageName = context.getPackageDeclaration().get().getName();
                return currentPackageName.equals((Object)importPackageName.get());
            }
            return false;
        }
        return true;
    }

    private static Optional<Name> getImportPackageName(ImportDeclaration importDeclaration) {
        return (importDeclaration.isAsterisk() ? new Name(importDeclaration.getName(), "*") : importDeclaration.getName()).getQualifier();
    }
}

