/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import java.util.Optional;
import java.util.Set;

public class UnnecessaryModifier
extends AJavaparserNodeMutator {
    public String minimalJavaVersion() {
        return "1";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"ExplicitToImplicit");
    }

    public boolean isDraft() {
        return false;
    }

    public Optional<String> getPmdId() {
        return Optional.of("UnnecessaryModifier");
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_codestyle.html#unnecessarymodifier";
    }

    public Optional<String> getCheckstyleId() {
        return Optional.of("RedundantModifier");
    }

    public String checkstyleUrl() {
        return "https://checkstyle.sourceforge.io/config_modifier.html#RedundantModifier";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-2333");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("RemoveModifiersInInterfaceProperties");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/remove-modifiers-in-interface-properties.html";
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> node) {
        if (!(node.getNode() instanceof Modifier)) {
            return false;
        }
        Modifier modifier = (Modifier)node.getNode();
        if (modifier.getParentNode().isEmpty()) {
            return false;
        }
        Node parentNode = (Node)modifier.getParentNode().get();
        if (!(parentNode instanceof MethodDeclaration || parentNode instanceof FieldDeclaration || parentNode instanceof ClassOrInterfaceDeclaration || parentNode instanceof AnnotationMemberDeclaration)) {
            return false;
        }
        if (parentNode.getParentNode().isEmpty()) {
            return false;
        }
        Node grandParentNode = (Node)parentNode.getParentNode().get();
        if (grandParentNode instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration grandParentInterface = (ClassOrInterfaceDeclaration)grandParentNode;
            if (!grandParentInterface.isInterface()) {
                return false;
            }
            if (modifier.getKeyword() == Modifier.Keyword.PUBLIC || modifier.getKeyword() == Modifier.Keyword.ABSTRACT || modifier.getKeyword() == Modifier.Keyword.FINAL || modifier.getKeyword() == Modifier.Keyword.STATIC && !(parentNode instanceof MethodDeclaration)) {
                return modifier.remove();
            }
            return false;
        }
        if (grandParentNode instanceof AnnotationDeclaration) {
            if (modifier.getKeyword() == Modifier.Keyword.PUBLIC || modifier.getKeyword() == Modifier.Keyword.ABSTRACT || modifier.getKeyword() == Modifier.Keyword.FINAL || modifier.getKeyword() == Modifier.Keyword.STATIC) {
                return modifier.remove();
            }
            return false;
        }
        return false;
    }
}

