/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnnecessaryBoxing
extends AJavaparserNodeMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnnecessaryBoxing.class);

    public String minimalJavaVersion() {
        return "1.1";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Primitive");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/primitive-boxed-for-string.html";
    }

    public String pmdUrl() {
        return "https://docs.pmd-code.org/pmd-doc-7.0.0-SNAPSHOT/pmd_rules_java_codestyle.html#unnecessaryboxing";
    }

    public Set<String> getPmdIds() {
        return Set.of("UnnecessaryBoxing", "UnnecessaryWrapperObjectCreation");
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-1158");
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> nodeAndSymbolSolver) {
        AtomicBoolean transformed = new AtomicBoolean();
        this.onMethodName(nodeAndSymbolSolver, "toString", (methodNode, scope, type) -> {
            if (this.process(nodeAndSymbolSolver.editNode(methodNode), scope, type)) {
                transformed.set(true);
            }
        });
        return transformed.get();
    }

    private boolean process(NodeAndSymbolSolver<?> nodeAndSymbolSolver, Expression scope, ResolvedType type) {
        if (!type.isReferenceType()) {
            return false;
        }
        LOGGER.debug("{} is referenceType", (Object)type);
        String primitiveQualifiedName = type.asReferenceType().getQualifiedName();
        if (Boolean.class.getName().equals(primitiveQualifiedName) || Byte.class.getName().equals(primitiveQualifiedName) || Short.class.getName().equals(primitiveQualifiedName) || Integer.class.getName().equals(primitiveQualifiedName) || Long.class.getName().equals(primitiveQualifiedName) || Float.class.getName().equals(primitiveQualifiedName) || Double.class.getName().equals(primitiveQualifiedName)) {
            LOGGER.debug("{} is AutoBoxed", (Object)type);
            if (scope instanceof ObjectCreationExpr) {
                ObjectCreationExpr creation = (ObjectCreationExpr)scope;
                NodeList inputs = creation.getArguments();
                MethodCallExpr replacement = new MethodCallExpr((Expression)new NameExpr(creation.getType().getName()), "toString", inputs);
                return this.tryReplace((Node)nodeAndSymbolSolver.getNode(), (Node)replacement);
            }
            if (scope instanceof MethodCallExpr) {
                MethodCallExpr call = (MethodCallExpr)scope;
                if (!"valueOf".equals(call.getNameAsString()) || call.getScope().isEmpty()) {
                    return false;
                }
                Expression calledScope = (Expression)call.getScope().get();
                Optional<ResolvedType> calledType = MethodCallExprHelpers.optResolvedType(nodeAndSymbolSolver.editNode(calledScope));
                if (calledType.isEmpty() || !calledType.get().isReferenceType()) {
                    return false;
                }
                ResolvedReferenceType referenceType = calledType.get().asReferenceType();
                if (referenceType.hasName() && primitiveQualifiedName.equals(referenceType.getQualifiedName())) {
                    MethodCallExpr replacement = new MethodCallExpr(calledScope, "toString", call.getArguments());
                    return this.tryReplace((Node)nodeAndSymbolSolver.getNode(), (Node)replacement);
                }
            }
        }
        return false;
    }
}

