/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserStmtMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.BinaryExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ImportDeclarationHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.LambdaExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyAfterMe;
import eu.solven.cleanthat.engine.java.refactorer.mutators.OptionalWrappedIfToFilter;
import eu.solven.cleanthat.engine.java.refactorer.mutators.OptionalWrappedVariableToMap;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplyAfterMe(value={OptionalWrappedIfToFilter.class, OptionalWrappedVariableToMap.class})
public class NullCheckToOptionalOfNullable
extends AJavaparserStmtMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NullCheckToOptionalOfNullable.class);
    final NullLiteralExpr nullLiteralExpr = new NullLiteralExpr();

    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Optional");
    }

    @Override
    protected boolean processStatement(NodeAndSymbolSolver<Statement> stmt) {
        if (!stmt.getNode().isIfStmt()) {
            return false;
        }
        IfStmt ifStmt = stmt.getNode().asIfStmt();
        Expression expr = ifStmt.getCondition();
        if (!expr.isBinaryExpr()) {
            return false;
        }
        if (ifStmt.getElseStmt().isPresent()) {
            return false;
        }
        BinaryExpr binaryExpr = expr.asBinaryExpr();
        BinaryExpr.Operator operator = binaryExpr.getOperator();
        if (operator != BinaryExpr.Operator.NOT_EQUALS) {
            return false;
        }
        Optional nameAndNull = BinaryExprHelpers.findPair(binaryExpr, e -> e.isNameExpr(), e -> e.isNullLiteralExpr());
        if (nameAndNull.isEmpty()) {
            return false;
        }
        Statement thenStmt = ifStmt.getThenStmt();
        String nullableVariableName = ((NameExpr)nameAndNull.get().getKey()).getNameAsString();
        SimpleName notNullVariableName = this.makeUnusedVariablename((Node)thenStmt, nullableVariableName);
        thenStmt.findAll(NameExpr.class, n -> n.getNameAsString().equals(nullableVariableName)).forEach(n -> n.replace((Node)new NameExpr(notNullVariableName)));
        Optional<LambdaExpr> optLambdaExpr = LambdaExprHelpers.makeLambdaExpr(notNullVariableName, thenStmt);
        if (optLambdaExpr.isEmpty()) {
            return false;
        }
        MethodCallExpr callOfNullable = new MethodCallExpr((Expression)ImportDeclarationHelpers.nameOrQualifiedName(stmt, Optional.class), "ofNullable", new NodeList((Node[])new Expression[]{(Expression)nameAndNull.get().getKey()}));
        MethodCallExpr callIfPresent = new MethodCallExpr((Expression)callOfNullable, "ifPresent", new NodeList((Node[])new Expression[]{(Expression)optLambdaExpr.get()}));
        return this.tryReplace((Node)ifStmt, (Node)new ExpressionStmt((Expression)callIfPresent));
    }

    @SuppressFBWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"})
    private SimpleName makeUnusedVariablename(Node context, String nameTemplate) {
        String nameCandidate;
        Object suffixCandidate = "_";
        while (true) {
            nameCandidate = nameTemplate + (String)suffixCandidate;
            Optional parentMethodDeclaration = context.findAncestor(new Class[]{MethodDeclaration.class});
            if (parentMethodDeclaration.isEmpty()) {
                return new SimpleName(nameCandidate);
            }
            Optional optConflict = ((MethodDeclaration)parentMethodDeclaration.get()).findFirst(NameExpr.class, n -> n.getNameAsString().equals(nameCandidate));
            if (!optConflict.isPresent()) break;
            LOGGER.debug("We can not use `{}` as it would conflict with another variable", (Object)nameCandidate);
            suffixCandidate = (String)suffixCandidate + "_";
        }
        return new SimpleName(nameCandidate);
    }
}

