/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserStmtMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ImportDeclarationHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.LambdaExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyAfterMe;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaReturnsSingleStatement;
import eu.solven.cleanthat.engine.java.refactorer.mutators.StreamWrappedVariableToMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;

@ApplyAfterMe(value={LambdaReturnsSingleStatement.class, StreamWrappedVariableToMap.class})
public class LoopIntRangeToIntStreamForEach
extends AJavaparserStmtMutator {
    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Primitive", (Object)"Loop", (Object)"Stream");
    }

    @Override
    protected boolean processStatement(NodeAndSymbolSolver<Statement> stmt) {
        if (!stmt.getNode().isForStmt()) {
            return false;
        }
        ForStmt forStmt = stmt.getNode().asForStmt();
        if (forStmt.getInitialization().size() != 1) {
            return false;
        }
        if (!((Expression)forStmt.getInitialization().get(0)).isVariableDeclarationExpr()) {
            return false;
        }
        VariableDeclarationExpr singleDeclaration = ((Expression)forStmt.getInitialization().get(0)).asVariableDeclarationExpr();
        if (singleDeclaration.getVariables().size() != 1) {
            return false;
        }
        VariableDeclarator singleVariable = (VariableDeclarator)singleDeclaration.getVariables().get(0);
        if (singleVariable.getInitializer().isEmpty()) {
            return false;
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(stmt.editNode(singleDeclaration), Integer.TYPE)) {
            return false;
        }
        if (forStmt.getCompare().isEmpty() || !((Expression)forStmt.getCompare().get()).isBinaryExpr()) {
            return false;
        }
        BinaryExpr compareBinaryExpr = ((Expression)forStmt.getCompare().get()).asBinaryExpr();
        NameExpr iteratedVariableName = new NameExpr(singleVariable.getName());
        if (compareBinaryExpr.getOperator() != BinaryExpr.Operator.LESS || !compareBinaryExpr.getLeft().equals((Object)iteratedVariableName)) {
            return false;
        }
        if (forStmt.getUpdate().size() != 1) {
            return false;
        }
        if (((Expression)forStmt.getUpdate().get(0)).isUnaryExpr()) {
            UnaryExpr unaryUpdate = ((Expression)forStmt.getUpdate().get(0)).asUnaryExpr();
            if (unaryUpdate.getOperator() != UnaryExpr.Operator.POSTFIX_INCREMENT && unaryUpdate.getOperator() != UnaryExpr.Operator.PREFIX_INCREMENT) {
                return false;
            }
        } else if (((Expression)forStmt.getUpdate().get(0)).isAssignExpr()) {
            AssignExpr assignExprUpdate = ((Expression)forStmt.getUpdate().get(0)).asAssignExpr();
            if (assignExprUpdate.getOperator() != AssignExpr.Operator.PLUS) {
                return false;
            }
            if (assignExprUpdate.getTarget().equals((Object)iteratedVariableName)) {
                return false;
            }
            if (new IntegerLiteralExpr("1").equals((Object)assignExprUpdate.getValue())) {
                return false;
            }
        } else {
            return false;
        }
        Statement body = forStmt.getBody();
        Optional<LambdaExpr> lambdaExpr = LambdaExprHelpers.makeLambdaExpr(singleVariable.getName(), body);
        if (lambdaExpr.isEmpty()) {
            return false;
        }
        Expression from = (Expression)singleVariable.getInitializer().get();
        Expression to = compareBinaryExpr.getRight();
        MethodCallExpr intRange = new MethodCallExpr((Expression)ImportDeclarationHelpers.nameOrQualifiedName(stmt, IntStream.class), "range", new NodeList((Node[])new Expression[]{from, to}));
        MethodCallExpr forEach = new MethodCallExpr((Expression)intRange, "forEach", new NodeList((Node[])new Expression[]{(Expression)lambdaExpr.get()}));
        return this.tryReplace((Node)forStmt, (Node)new ExpressionStmt((Expression)forEach));
    }
}

