/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserStmtMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.LambdaExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyAfterMe;
import eu.solven.cleanthat.engine.java.refactorer.mutators.ForEachIfToIfStreamAnyMatch;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaIsMethodReference;
import eu.solven.cleanthat.engine.java.refactorer.mutators.StreamMutatorHelpers;
import java.util.Optional;
import java.util.Set;

@ApplyAfterMe(value={LambdaIsMethodReference.class})
public class ForEachIfBreakElseToStreamTakeWhile
extends AJavaparserStmtMutator {
    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Stream", (Object)"Loop");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("EnhancedForLoopToStreamTakeWhile");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/enhanced-for-loop-to-stream-take-while.html";
    }

    @Override
    protected boolean processStatement(NodeAndSymbolSolver<Statement> stmt) {
        if (!stmt.getNode().isForEachStmt()) {
            return false;
        }
        ForEachStmt forEachStmt = stmt.getNode().asForEachStmt();
        if (!forEachStmt.getBody().isBlockStmt()) {
            return false;
        }
        BlockStmt forEachBlock = forEachStmt.getBody().asBlockStmt();
        if (forEachBlock.getStatements().size() <= 1) {
            return false;
        }
        Optional<IfStmt> optIfStmt = StreamMutatorHelpers.findSingleIfThenStmt((Statement)forEachBlock.getStatements().get(0));
        if (optIfStmt.isEmpty()) {
            return false;
        }
        IfStmt ifStmt = optIfStmt.get();
        Optional<LambdaExpr> filterArgument = ForEachIfToIfStreamAnyMatch.ifConditionToLambda(ifStmt, forEachStmt.getVariable().getVariable(0));
        if (filterArgument.isEmpty()) {
            return false;
        }
        BlockStmt streamForEachBlock = forEachBlock.clone();
        streamForEachBlock.getStatements().remove(0);
        Optional<LambdaExpr> lambdaExpr = LambdaExprHelpers.makeLambdaExpr(forEachStmt.getVariable().getVariable(0).getName(), streamForEachBlock);
        if (lambdaExpr.isEmpty()) {
            return false;
        }
        forEachBlock.getStatements().remove(0);
        MethodCallExpr stream = new MethodCallExpr(forEachStmt.getIterable(), "stream");
        MethodCallExpr takeWhile = new MethodCallExpr((Expression)stream, "takeWhile", new NodeList((Node[])new Expression[]{(Expression)filterArgument.get()}));
        MethodCallExpr forEach = new MethodCallExpr((Expression)takeWhile, "forEach", new NodeList((Node[])new Expression[]{(Expression)lambdaExpr.get()}));
        return this.tryReplace((Node)forEachStmt, (Node)new ExpressionStmt((Expression)forEach));
    }
}

