/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.BinaryExprHelpers;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ArithmethicAssignment
extends AJavaparserExprMutator {
    private static final Set<BinaryExpr.Operator> MAY_TURN_ASSIGN_OPERATOR = Set.of(BinaryExpr.Operator.PLUS, BinaryExpr.Operator.MINUS, BinaryExpr.Operator.MULTIPLY, BinaryExpr.Operator.DIVIDE);
    private static final Set<BinaryExpr.Operator> SYMETRIC_OPERATORS = Set.of(BinaryExpr.Operator.PLUS, BinaryExpr.Operator.MULTIPLY);

    public Optional<String> getJSparrowId() {
        return Optional.of("ArithmethicAssignment");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/arithmethic-assignment.html";
    }

    public String minimalJavaVersion() {
        return "1";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-2164");
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Primitive");
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isAssignExpr()) {
            return false;
        }
        AssignExpr assignExpr = expr.getNode().asAssignExpr();
        if (assignExpr.getOperator() != AssignExpr.Operator.ASSIGN) {
            return false;
        }
        if (!assignExpr.getTarget().isNameExpr()) {
            return false;
        }
        if (!assignExpr.getValue().isBinaryExpr()) {
            return false;
        }
        NameExpr target = assignExpr.getTarget().asNameExpr();
        BinaryExpr binaryExpr = assignExpr.getValue().asBinaryExpr();
        Optional<Map.Entry<Object, Object>> optValueIfValue = SYMETRIC_OPERATORS.contains(binaryExpr.getOperator()) ? BinaryExprHelpers.findPair(binaryExpr, n -> n.equals((Object)target), n -> true) : (binaryExpr.getLeft().equals((Object)target) ? Optional.of(Maps.immutableEntry((Object)binaryExpr.getLeft(), (Object)binaryExpr.getRight())) : Optional.empty());
        if (optValueIfValue.isEmpty()) {
            return false;
        }
        if (!MAY_TURN_ASSIGN_OPERATOR.contains(binaryExpr.getOperator())) {
            return false;
        }
        boolean replaced = this.tryReplace((Node)binaryExpr, (Node)optValueIfValue.get().getValue());
        if (replaced) {
            assignExpr.setOperator(this.toAssignOperator(binaryExpr.getOperator()));
        }
        return replaced;
    }

    private AssignExpr.Operator toAssignOperator(BinaryExpr.Operator operator) {
        switch (operator) {
            case PLUS: {
                return AssignExpr.Operator.PLUS;
            }
            case MINUS: {
                return AssignExpr.Operator.MINUS;
            }
            case MULTIPLY: {
                return AssignExpr.Operator.MULTIPLY;
            }
            case DIVIDE: {
                return AssignExpr.Operator.DIVIDE;
            }
        }
        throw new IllegalArgumentException("Invalid operator: " + operator);
    }
}

