/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AUseXIsEmpty
extends AJavaparserExprMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AUseXIsEmpty.class);
    private static final IntegerLiteralExpr ZERO_EXPR = new IntegerLiteralExpr("0");

    protected abstract String getSizeMethod();

    protected abstract Set<Class<?>> getCompatibleTypes();

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        Optional<Expression> optLengthScope = this.checkCallSizeAndCompareWith0(this.getSizeMethod(), expr);
        if (optLengthScope.isEmpty()) {
            return false;
        }
        Expression lengthScope = optLengthScope.get();
        Optional<ResolvedType> type = MethodCallExprHelpers.optResolvedType(expr.editNode(lengthScope));
        if (type.isPresent()) {
            return this.checkTypeAndProcess((Node)expr.getNode(), lengthScope, type.get());
        }
        return false;
    }

    protected Optional<Expression> checkCallSizeAndCompareWith0(String methodName, NodeAndSymbolSolver<Expression> expr) {
        Expression node = expr.getNode();
        if (!(node instanceof BinaryExpr)) {
            return Optional.empty();
        }
        BinaryExpr binaryExpr = (BinaryExpr)node;
        if (!BinaryExpr.Operator.EQUALS.equals((Object)binaryExpr.getOperator())) {
            return Optional.empty();
        }
        Optional<Object> checkmeForIsEmpty = ZERO_EXPR.equals((Object)binaryExpr.getRight()) && binaryExpr.getLeft() instanceof MethodCallExpr ? Optional.of((MethodCallExpr)binaryExpr.getLeft()) : (ZERO_EXPR.equals((Object)binaryExpr.getLeft()) && binaryExpr.getRight() instanceof MethodCallExpr ? Optional.of((MethodCallExpr)binaryExpr.getRight()) : Optional.empty());
        if (checkmeForIsEmpty.isEmpty()) {
            return Optional.empty();
        }
        Optional optLengthScope = ((MethodCallExpr)checkmeForIsEmpty.get()).getScope();
        if (optLengthScope.isEmpty()) {
            return Optional.empty();
        }
        String calledMethodName = ((MethodCallExpr)checkmeForIsEmpty.get()).getNameAsString();
        if (!methodName.equals(calledMethodName)) {
            LOGGER.debug("Not calling `.{}()`", (Object)methodName);
            return Optional.empty();
        }
        return optLengthScope;
    }

    protected boolean checkTypeAndProcess(Node node, Expression lengthScope, ResolvedType type) {
        boolean transformed;
        if (type.isReferenceType()) {
            LOGGER.debug("scope={} type={}", (Object)lengthScope, (Object)type);
            boolean doIt = false;
            ResolvedReferenceType referenceType = type.asReferenceType();
            if (referenceType.getQualifiedName().equals(String.class.getName())) {
                doIt = true;
            } else {
                try {
                    Class<?> clazz = Class.forName(referenceType.getQualifiedName());
                    if (this.getCompatibleTypes().stream().anyMatch(c -> c.isAssignableFrom(clazz))) {
                        doIt = true;
                    }
                }
                catch (ClassNotFoundException | RuntimeException e) {
                    LOGGER.debug("This class is not available. Can not confirm it is a String");
                }
            }
            transformed = doIt ? this.tryReplace(node, (Node)new MethodCallExpr(lengthScope, "isEmpty")) : false;
        } else {
            transformed = false;
        }
        return transformed;
    }
}

