/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.helpers;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.types.ResolvedType;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ResolvedTypeHelpers;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodCallExprHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodCallExprHelpers.class);

    protected MethodCallExprHelpers() {
    }

    public static boolean scopeHasRequiredType(NodeAndSymbolSolver<? extends Expression> node, Class<?> requiredType) {
        return MethodCallExprHelpers.scopeHasRequiredType(node.getSymbolResolver(), Optional.of(node.getNode()), requiredType);
    }

    public static boolean scopeHasRequiredType(Optional<NodeAndSymbolSolver<? extends Expression>> optNode, Class<?> expectedScope) {
        if (optNode.isEmpty()) {
            return false;
        }
        return MethodCallExprHelpers.scopeHasRequiredType(optNode.get(), expectedScope);
    }

    public static boolean scopeHasRequiredType(SymbolResolver symbolResolver, Optional<Expression> optScope, Class<?> requiredType) {
        return MethodCallExprHelpers.scopeHasRequiredType(symbolResolver, optScope, requiredType.getName());
    }

    public static boolean scopeHasRequiredType(SymbolResolver symbolResolver, Optional<Expression> optScope, String requiredType) {
        Optional<ResolvedType> optType = optScope.flatMap(scope -> MethodCallExprHelpers.optResolvedType(symbolResolver, scope));
        return ResolvedTypeHelpers.typeIsAssignable(optType, requiredType);
    }

    public static Optional<ResolvedType> optResolvedType(NodeAndSymbolSolver<? extends Expression> expr) {
        return MethodCallExprHelpers.optResolvedType(expr.getSymbolResolver(), expr.getNode());
    }

    public static Optional<ResolvedType> optResolvedType(Optional<NodeAndSymbolSolver<? extends Expression>> optExpr) {
        if (optExpr.isEmpty()) {
            return Optional.empty();
        }
        return MethodCallExprHelpers.optResolvedType(optExpr.get());
    }

    public static Optional<ResolvedType> optResolvedType(SymbolResolver symbolResolver, Expression expr) {
        try {
            ResolvedType type = symbolResolver.calculateType(expr);
            return Optional.of(type);
        }
        catch (RuntimeException e) {
            try {
                ResolvedType secondTryType = expr.calculateResolvedType();
                AJavaparserNodeMutator.logJavaParserIssue(expr, e, "https://github.com/javaparser/javaparser/issues/3939");
                return Optional.of(secondTryType);
            }
            catch (RuntimeException ee) {
                LOGGER.debug("Issue resolving the type of {}", (Object)expr, (Object)ee);
                return Optional.empty();
            }
            catch (NoClassDefFoundError ee) {
                AJavaparserNodeMutator.logJavaParserIssue(expr, e, "https://github.com/javaparser/javaparser/issues/3504");
                return Optional.empty();
            }
        }
        catch (NoClassDefFoundError e) {
            AJavaparserNodeMutator.logJavaParserIssue(expr, e, "https://github.com/javaparser/javaparser/issues/3504");
            return Optional.empty();
        }
    }

    @SafeVarargs
    public static Optional<MethodCallExpr> match(NodeAndSymbolSolver<Expression> expr, Class<?> scope, String methodName, Predicate<Expression> ... acceptArguments) {
        if (!expr.getNode().isMethodCallExpr()) {
            return Optional.empty();
        }
        MethodCallExpr methodCallExpr = expr.getNode().asMethodCallExpr();
        if (!methodName.equals(methodCallExpr.getNameAsString())) {
            return Optional.empty();
        }
        if (methodCallExpr.getArguments().size() != acceptArguments.length) {
            return Optional.empty();
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.getSymbolResolver(), (Optional<Expression>)methodCallExpr.getScope(), scope)) {
            return Optional.empty();
        }
        for (int i = 0; i < acceptArguments.length; ++i) {
            Predicate<Expression> argumentPredicate = acceptArguments[i];
            Expression flatMapArgument = methodCallExpr.getArgument(i);
            if (argumentPredicate.test(flatMapArgument)) continue;
            return Optional.empty();
        }
        return Optional.of(methodCallExpr);
    }
}

