/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.config.pojo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.collect.ImmutableList;
import eu.solven.cleanthat.github.IGitRefsConstants;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonIgnoreProperties(value={"branches"})
public final class CleanthatRefFilterProperties
implements IGitRefsConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanthatRefFilterProperties.class);
    public static final List<String> SIMPLE_DEFAULT_BRANCHES = ImmutableList.of((Object)"develop", (Object)"main", (Object)"master");
    private List<String> protectedPatterns = SIMPLE_DEFAULT_BRANCHES.stream().map(s -> "refs/heads/" + s).collect(Collectors.toList());
    private List<String> excludedPatterns = ImmutableList.of((Object)"refs/heads/release/*");

    private ImmutableList<String> cleanRefs(List<String> protectedPatterns) {
        return (ImmutableList)protectedPatterns.stream().map(branch -> {
            if (!branch.startsWith("refs/")) {
                String qualifiedRef = "refs/heads/" + branch;
                LOGGER.debug("We qualify {} into {} (i.e. we supposed it is a branch name)", branch, (Object)qualifiedRef);
                return qualifiedRef;
            }
            if (!branch.startsWith("refs/heads/")) {
                LOGGER.warn("Unusual protected ref: {}", branch);
            }
            return branch;
        }).distinct().collect(ImmutableList.toImmutableList());
    }

    public void setProtectedPatterns(List<String> protectedPatterns) {
        this.protectedPatterns = this.cleanRefs(protectedPatterns);
    }

    public void setExcludedPatterns(List<String> excludedPatterns) {
        this.excludedPatterns = this.cleanRefs(excludedPatterns);
    }

    public List<String> getProtectedPatterns() {
        return this.protectedPatterns;
    }

    public List<String> getExcludedPatterns() {
        return this.excludedPatterns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CleanthatRefFilterProperties)) {
            return false;
        }
        CleanthatRefFilterProperties other = (CleanthatRefFilterProperties)o;
        List<String> this$protectedPatterns = this.getProtectedPatterns();
        List<String> other$protectedPatterns = other.getProtectedPatterns();
        if (this$protectedPatterns == null ? other$protectedPatterns != null : !((Object)this$protectedPatterns).equals(other$protectedPatterns)) {
            return false;
        }
        List<String> this$excludedPatterns = this.getExcludedPatterns();
        List<String> other$excludedPatterns = other.getExcludedPatterns();
        return !(this$excludedPatterns == null ? other$excludedPatterns != null : !((Object)this$excludedPatterns).equals(other$excludedPatterns));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $protectedPatterns = this.getProtectedPatterns();
        result = result * 59 + ($protectedPatterns == null ? 43 : ((Object)$protectedPatterns).hashCode());
        List<String> $excludedPatterns = this.getExcludedPatterns();
        result = result * 59 + ($excludedPatterns == null ? 43 : ((Object)$excludedPatterns).hashCode());
        return result;
    }

    public String toString() {
        return "CleanthatRefFilterProperties(protectedPatterns=" + this.getProtectedPatterns() + ", excludedPatterns=" + this.getExcludedPatterns() + ")";
    }
}

