/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.codeprovider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import eu.solven.cleanthat.code_provider.CleanthatPathHelpers;
import eu.solven.cleanthat.codeprovider.ICodeProvider;
import eu.solven.cleanthat.codeprovider.IGitSha1CodeProvider;
import eu.solven.cleanthat.config.ConfigHelpers;
import eu.solven.cleanthat.config.ICleanthatConfigConstants;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeProviderHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeProviderHelpers.class);
    protected Collection<ObjectMapper> objectMappers;

    public CodeProviderHelpers(Collection<ObjectMapper> objectMappers) {
        this.objectMappers = objectMappers;
    }

    public Optional<Map<String, ?>> unsafeConfig(ICodeProvider codeProvider) {
        ObjectMapper objectMapper;
        Optional optPathAndContent = ICleanthatConfigConstants.PATHES_CLEANTHAT.stream().map(p -> {
            try {
                Path resolvedPath = CleanthatPathHelpers.makeContentPath((Path)codeProvider.getRepositoryRoot(), (String)p);
                return codeProvider.loadContentForPath(resolvedPath).map(content -> Maps.immutableEntry((Object)p, (Object)content));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }).flatMap(Optional::stream).findFirst();
        if (optPathAndContent.isEmpty()) {
            return Optional.empty();
        }
        Map.Entry pathAndContent = (Map.Entry)optPathAndContent.get();
        String sha1ForLog = codeProvider instanceof IGitSha1CodeProvider ? ((IGitSha1CodeProvider)((Object)codeProvider)).getSha1() : codeProvider.getClass().getName();
        LOGGER.info("Loaded config from {} from sha1={}", pathAndContent.getKey(), (Object)sha1ForLog);
        if (((String)pathAndContent.getKey()).endsWith(".json")) {
            objectMapper = ConfigHelpers.getJson(this.objectMappers);
        } else if (((String)pathAndContent.getKey()).endsWith(".yml") || ((String)pathAndContent.getKey()).endsWith(".yaml")) {
            objectMapper = ConfigHelpers.getYaml(this.objectMappers);
        } else {
            throw new IllegalArgumentException("Not managed extention: " + (String)pathAndContent.getKey());
        }
        return optPathAndContent.map(content -> {
            try {
                return (Map)objectMapper.readValue((String)content.getValue(), Map.class);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Invalid config (json vs yaml?)", e);
            }
        });
    }

    public static Optional<File> pathToConfig(Path localFolder) {
        return ICleanthatConfigConstants.PATHES_CLEANTHAT.stream().map(s -> {
            File file = CleanthatPathHelpers.resolveChild((Path)localFolder, (String)s).toFile();
            return file;
        }).filter(File::exists).findAny();
    }

    public static Path getRoot(Path path) {
        return CodeProviderHelpers.getRoot(path.getFileSystem());
    }

    public static Path getRoot(FileSystem fs) {
        return fs.getPath(fs.getSeparator(), new String[0]);
    }
}

