/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine;

import eu.solven.cleanthat.engine.IEngineFormatterFactory;
import eu.solven.cleanthat.engine.IEngineLintFixerFactory;
import eu.solven.cleanthat.language.IEngineProperties;
import java.util.Map;
import java.util.Set;

public class StringFormatterFactory
implements IEngineFormatterFactory {
    final Map<String, IEngineLintFixerFactory> engineToFormatter;

    public StringFormatterFactory(Map<String, IEngineLintFixerFactory> languageToFormatter) {
        this.engineToFormatter = languageToFormatter;
    }

    @Override
    public IEngineLintFixerFactory makeLanguageFormatter(IEngineProperties engineProperties) {
        String engine = engineProperties.getEngine();
        return this.makeLanguageFormatter(engine);
    }

    private IEngineLintFixerFactory makeLanguageFormatter(String engine) {
        IEngineLintFixerFactory formatter = this.engineToFormatter.get(engine);
        if (formatter == null) {
            throw new IllegalArgumentException("There is no formatter for engine=" + engine + " available engines=" + this.engineToFormatter.keySet());
        }
        return formatter;
    }

    @Override
    public Set<String> getDefaultIncludes(String engine) {
        IEngineLintFixerFactory engineFactory = this.makeLanguageFormatter(engine);
        return engineFactory.getDefaultIncludes();
    }
}

