/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.formatter;

import eu.solven.cleanthat.config.pojo.CleanthatStepProperties;
import eu.solven.cleanthat.engine.EngineAndLinters;
import eu.solven.cleanthat.engine.IEngineLintFixerFactory;
import eu.solven.cleanthat.formatter.CleanthatSession;
import eu.solven.cleanthat.formatter.ILintFixer;
import eu.solven.cleanthat.language.IEngineProperties;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceCodeFormatterHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceCodeFormatterHelper.class);

    public EngineAndLinters compile(IEngineProperties engineProperties, CleanthatSession cleanthatSession, IEngineLintFixerFactory lintFixerFactory) {
        List<ILintFixer> linters = this.prepareLintFixers(engineProperties, cleanthatSession, lintFixerFactory);
        String engine = engineProperties.getEngine();
        LOGGER.info("engine={} has prepared {} lintFixers", (Object)engine, (Object)linters.size());
        linters.forEach(lf -> LOGGER.info("engine={} relies on {}", (Object)engine, (Object)lf.getClass().getName()));
        return new EngineAndLinters(engineProperties, linters);
    }

    public List<ILintFixer> prepareLintFixers(IEngineProperties engineProperties, CleanthatSession cleanthatSession, IEngineLintFixerFactory lintFixerFactory) {
        return engineProperties.getSteps().stream().filter(Predicate.not(CleanthatStepProperties::isSkip)).map(step -> lintFixerFactory.makeLintFixer(cleanthatSession, engineProperties, (CleanthatStepProperties)step)).collect(Collectors.toList());
    }
}

