/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.formatter;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.AtomicLongMap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import eu.solven.cleanthat.any_language.ACodeCleaner;
import eu.solven.cleanthat.codeprovider.CodeProviderDecoratingWriter;
import eu.solven.cleanthat.codeprovider.CodeWritingMetadata;
import eu.solven.cleanthat.codeprovider.ICodeProvider;
import eu.solven.cleanthat.codeprovider.ICodeProviderFile;
import eu.solven.cleanthat.codeprovider.ICodeProviderWriter;
import eu.solven.cleanthat.codeprovider.ICodeWritingMetadata;
import eu.solven.cleanthat.codeprovider.IUpgradableToHeadFullScan;
import eu.solven.cleanthat.config.ConfigHelpers;
import eu.solven.cleanthat.config.IncludeExcludeHelpers;
import eu.solven.cleanthat.config.pojo.CleanthatEngineProperties;
import eu.solven.cleanthat.config.pojo.CleanthatRepositoryProperties;
import eu.solven.cleanthat.engine.EngineAndLinters;
import eu.solven.cleanthat.engine.ICodeFormatterApplier;
import eu.solven.cleanthat.engine.IEngineFormatterFactory;
import eu.solven.cleanthat.engine.IEngineLintFixerFactory;
import eu.solven.cleanthat.formatter.CleanthatSession;
import eu.solven.cleanthat.formatter.CodeFormatResult;
import eu.solven.cleanthat.formatter.ICodeProviderFormatter;
import eu.solven.cleanthat.formatter.PathAndContent;
import eu.solven.cleanthat.formatter.SourceCodeFormatterHelper;
import eu.solven.cleanthat.github.IHasSourceCodeProperties;
import eu.solven.cleanthat.language.IEngineProperties;
import eu.solven.cleanthat.language.ISourceCodeProperties;
import eu.solven.pepper.thread.PepperExecutorsHelper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeProviderFormatter
implements ICodeProviderFormatter {
    private static final String KEY_NB_FILES_FORMATTED = "nb_files_formatted";
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeProviderFormatter.class);
    public static final String EOL = "\r\n";
    private static final int MAX_LOG_MANY_FILES = 128;
    final IEngineFormatterFactory formatterFactory;
    final ICodeFormatterApplier formatterApplier;
    final SourceCodeFormatterHelper sourceCodeFormatterHelper;
    final ConfigHelpers configHelpers;

    public CodeProviderFormatter(ConfigHelpers configHelpers, IEngineFormatterFactory formatterFactory, ICodeFormatterApplier formatterApplier) {
        this.configHelpers = configHelpers;
        this.formatterFactory = formatterFactory;
        this.formatterApplier = formatterApplier;
        this.sourceCodeFormatterHelper = new SourceCodeFormatterHelper();
    }

    @Override
    public CodeFormatResult formatCode(CleanthatRepositoryProperties repoProperties, ICodeProviderWriter codeWriter, boolean dryRun) {
        boolean isEmpty;
        ICodeProviderWriter finalCodeWriter;
        AtomicBoolean configIsChanged = new AtomicBoolean();
        ArrayList prComments = new ArrayList();
        if (ACodeCleaner.isLimittedSetOfFiles((ICodeProvider)codeWriter)) {
            try {
                codeWriter.listFilesForFilenames(fileChanged -> {
                    Path path = fileChanged.getPath();
                    if (path.startsWith(".cleanthat")) {
                        configIsChanged.set(true);
                        prComments.add("Spotless configuration has changed");
                        LOGGER.info("Configuration change over path=`{}`", (Object)path);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException("Issue while checking for config change", e);
            }
            if (configIsChanged.get()) {
                if (repoProperties.getMeta().isFullCleanOnConfigurationChange()) {
                    LOGGER.info("The configuration has changed, then we will process all files in the repository");
                    finalCodeWriter = this.upgradeToFullRepoReader(codeWriter);
                } else {
                    LOGGER.info("The configuration has changed, but $.meta.full_clean_on_configuration_change=false");
                    finalCodeWriter = codeWriter;
                }
            } else {
                finalCodeWriter = codeWriter;
            }
        } else {
            LOGGER.debug("We will clean everything");
            finalCodeWriter = codeWriter;
        }
        AtomicLongMap languageToNbAddedFiles = AtomicLongMap.create();
        AtomicLongMap languagesCounters = AtomicLongMap.create();
        LinkedHashMap pathToMutatedContent = new LinkedHashMap();
        CleanthatSession cleanthatSession = new CleanthatSession(codeWriter.getRepositoryRoot(), (ICodeProvider)finalCodeWriter, repoProperties);
        repoProperties.getEngines().stream().filter(lp -> !lp.isSkip()).forEach(dirtyLanguageConfig -> {
            IEngineProperties languageP = this.prepareLanguageConfiguration(repoProperties, (CleanthatEngineProperties)dirtyLanguageConfig);
            AtomicLongMap<String> languageCounters = this.processFiles(cleanthatSession, (AtomicLongMap<String>)languageToNbAddedFiles, pathToMutatedContent, languageP);
            String details = languageCounters.asMap().entrySet().stream().map(e -> (String)e.getKey() + ": " + e.getValue()).collect(Collectors.joining(EOL));
            prComments.add("engine=" + languageP.getEngine() + EOL + details);
            languageCounters.asMap().forEach((l, c) -> languagesCounters.addAndGet(l, c.longValue()));
        });
        if (languageToNbAddedFiles.isEmpty() && !configIsChanged.get()) {
            LOGGER.info("Not a single file to commit ({})", (Object)codeWriter);
            isEmpty = true;
        } else {
            LOGGER.info("About to commit+push {} files into {} (configChange={})", new Object[]{languageToNbAddedFiles.sum(), codeWriter, configIsChanged.get()});
            if (dryRun) {
                LOGGER.info("Skip persisting changes as dryRun=true");
                isEmpty = true;
            } else {
                CodeWritingMetadata metadata = new CodeWritingMetadata(prComments, repoProperties.getMeta().getLabels());
                isEmpty = !codeWriter.persistChanges(pathToMutatedContent, (ICodeWritingMetadata)metadata);
            }
        }
        codeWriter.cleanTmpFiles();
        return new CodeFormatResult(isEmpty, new LinkedHashMap(languagesCounters.asMap()));
    }

    private ICodeProviderWriter upgradeToFullRepoReader(ICodeProviderWriter codeWriter) {
        ICodeProviderWriter codeProvider = codeWriter;
        while (codeProvider instanceof CodeProviderDecoratingWriter) {
            codeProvider = ((CodeProviderDecoratingWriter)codeWriter).getDecorated();
        }
        if (codeProvider instanceof IUpgradableToHeadFullScan) {
            codeProvider = ((IUpgradableToHeadFullScan)codeProvider).upgradeToFullScan();
        } else {
            LOGGER.warn("TODO {} does not implements {}", (Object)codeProvider.getClass().getName(), (Object)IUpgradableToHeadFullScan.class.getName());
        }
        CodeProviderDecoratingWriter fullRepoCodeWriter = new CodeProviderDecoratingWriter((ICodeProvider)codeProvider, () -> codeWriter);
        LOGGER.info("We upgraded {} to {}", (Object)codeWriter, (Object)fullRepoCodeWriter);
        return fullRepoCodeWriter;
    }

    private IEngineProperties prepareLanguageConfiguration(CleanthatRepositoryProperties repoProperties, CleanthatEngineProperties dirtyEngine) {
        IEngineProperties cleanEngine = this.configHelpers.mergeEngineProperties((IHasSourceCodeProperties)repoProperties, (IEngineProperties)dirtyEngine);
        String language = cleanEngine.getEngine();
        LOGGER.info("About to prepare files for language: {}", (Object)language);
        ISourceCodeProperties sourceCodeProperties = cleanEngine.getSourceCode();
        List includes = cleanEngine.getSourceCode().getIncludes();
        if (includes.isEmpty()) {
            Set<String> defaultIncludes = this.formatterFactory.getDefaultIncludes(cleanEngine.getEngine());
            LOGGER.info("Default includes to: {}", defaultIncludes);
            cleanEngine = this.configHelpers.forceIncludes(cleanEngine, defaultIncludes);
            sourceCodeProperties = cleanEngine.getSourceCode();
            includes = cleanEngine.getSourceCode().getIncludes();
        }
        LOGGER.info("language={} Applying includes rules: {}", (Object)language, (Object)includes);
        LOGGER.info("language={} Applying excludes rules: {}", (Object)language, (Object)sourceCodeProperties.getExcludes());
        return cleanEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AtomicLongMap<String> processFiles(CleanthatSession cleanthatSession, AtomicLongMap<String> engineToNbMutatedFiles, Map<Path, String> pathToMutatedContent, IEngineProperties engineP) {
        ArrayList closeUs = new ArrayList();
        ThreadLocal<EngineAndLinters> currentThreadEngine = ThreadLocal.withInitial(() -> {
            EngineAndLinters lintFixer = this.buildProcessors(engineP, cleanthatSession);
            closeUs.add(lintFixer);
            return lintFixer;
        });
        try {
            AtomicLongMap<String> languageCounters = this.processFiles(cleanthatSession, pathToMutatedContent, engineP, currentThreadEngine);
            engineToNbMutatedFiles.addAndGet((Object)engineP.getEngine(), languageCounters.get((Object)KEY_NB_FILES_FORMATTED));
            AtomicLongMap<String> atomicLongMap = languageCounters;
            return atomicLongMap;
        }
        finally {
            closeUs.forEach(t -> {
                try {
                    t.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Issue while closing {}", t, (Object)e);
                }
            });
        }
    }

    protected AtomicLongMap<String> processFiles(CleanthatSession cleanthatSession, Map<Path, String> pathToMutatedContent, IEngineProperties engineP, ThreadLocal<EngineAndLinters> currentThreadEngine) {
        ISourceCodeProperties sourceCodeProperties = engineP.getSourceCode();
        AtomicLongMap languageCounters = AtomicLongMap.create();
        FileSystem fs = cleanthatSession.getRepositoryRoot().getFileSystem();
        List includeMatchers = IncludeExcludeHelpers.prepareMatcher((FileSystem)fs, (Collection)sourceCodeProperties.getIncludes());
        List excludeMatchers = IncludeExcludeHelpers.prepareMatcher((FileSystem)fs, (Collection)sourceCodeProperties.getExcludes());
        ListeningExecutorService executor = PepperExecutorsHelper.newShrinkableFixedThreadPool((String)"Cleanthat-CodeFormatter-");
        ExecutorCompletionService cs = new ExecutorCompletionService((Executor)executor);
        try {
            cleanthatSession.getCodeProvider().listFilesForContent(file -> {
                Optional<Callable<Boolean>> optRunMe = this.onEachFile(cleanthatSession, pathToMutatedContent, currentThreadEngine, (AtomicLongMap<String>)languageCounters, includeMatchers, excludeMatchers, (ICodeProviderFile)file);
                optRunMe.ifPresent(cs::submit);
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Issue listing files", e);
        }
        finally {
            if (!MoreExecutors.shutdownAndAwaitTermination((ExecutorService)executor, (long)1L, (TimeUnit)TimeUnit.DAYS)) {
                LOGGER.warn("Executor not terminated");
            }
        }
        try {
            Future polled;
            while ((polled = cs.poll()) != null) {
                boolean result = (Boolean)polled.get();
                if (result) {
                    languageCounters.incrementAndGet((Object)KEY_NB_FILES_FORMATTED);
                    continue;
                }
                languageCounters.incrementAndGet((Object)"nb_files_already_formatted");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Issue while one of the asynchronous tasks", e);
        }
        return languageCounters;
    }

    private Optional<Callable<Boolean>> onEachFile(CleanthatSession cleanthatSession, Map<Path, String> pathToMutatedContent, ThreadLocal<EngineAndLinters> currentThreadEngine, AtomicLongMap<String> languageCounters, List<PathMatcher> includeMatchers, List<PathMatcher> excludeMatchers, ICodeProviderFile file) {
        Path filePath = file.getPath();
        Optional matchingInclude = IncludeExcludeHelpers.findMatching(includeMatchers, (Path)filePath);
        Optional matchingExclude = IncludeExcludeHelpers.findMatching(excludeMatchers, (Path)filePath);
        if (matchingInclude.isPresent()) {
            if (matchingExclude.isEmpty()) {
                Callable<Boolean> runMe = () -> {
                    EngineAndLinters engineSteps = (EngineAndLinters)currentThreadEngine.get();
                    try {
                        return this.doFormat(cleanthatSession, engineSteps, pathToMutatedContent, filePath);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Issue with file: " + filePath, e);
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException("Issue with file: " + filePath, e);
                    }
                };
                return Optional.of(runMe);
            }
            languageCounters.incrementAndGet((Object)"nb_files_both_included_excluded");
            return Optional.empty();
        }
        if (matchingExclude.isPresent()) {
            languageCounters.incrementAndGet((Object)"nb_files_excluded_not_included");
            return Optional.empty();
        }
        languageCounters.incrementAndGet((Object)"nb_files_neither_included_nor_excluded");
        return Optional.empty();
    }

    private boolean doFormat(CleanthatSession cleanthatSession, EngineAndLinters engineAndLinters, Map<Path, String> pathToMutatedContent, Path filePath) throws IOException {
        Optional<String> optCode = this.loadCodeOptMutated(cleanthatSession.getCodeProvider(), pathToMutatedContent, filePath);
        if (optCode.isEmpty()) {
            LOGGER.warn("Skip processing {} as its content is not available", (Object)filePath);
            return false;
        }
        String code = optCode.get();
        LOGGER.debug("Processing path={}", (Object)filePath);
        String output = this.doFormat(engineAndLinters, new PathAndContent(filePath, code));
        if (!Strings.isNullOrEmpty((String)output) && !code.equals(output)) {
            LOGGER.info("Path={} successfully cleaned by {}", (Object)filePath, (Object)engineAndLinters);
            pathToMutatedContent.put(filePath, output);
            if (pathToMutatedContent.size() > 128 && Integer.bitCount(pathToMutatedContent.size()) == 1) {
                LOGGER.warn("We are about to commit {} files. That's quite a lot.", (Object)pathToMutatedContent.size());
            }
            return true;
        }
        return false;
    }

    public Optional<String> loadCodeOptMutated(ICodeProvider codeProvider, Map<Path, String> pathToMutatedContent, Path filePath) {
        Optional<String> optAlreadyMutated = Optional.ofNullable(pathToMutatedContent.get(filePath));
        if (optAlreadyMutated.isPresent()) {
            return optAlreadyMutated;
        }
        try {
            return codeProvider.loadContentForPath(filePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private EngineAndLinters buildProcessors(IEngineProperties properties, CleanthatSession cleanthatSession) {
        IEngineLintFixerFactory formattersFactory = this.formatterFactory.makeLanguageFormatter(properties);
        return this.sourceCodeFormatterHelper.compile(properties, cleanthatSession, formattersFactory);
    }

    private String doFormat(EngineAndLinters compiledProcessors, PathAndContent pathAndContent) throws IOException {
        return this.formatterApplier.applyProcessors(compiledProcessors, pathAndContent);
    }
}

