/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.code_provider.github;

import eu.solven.cleanthat.code_provider.github.event.CompositeCodeCleanerFactory;
import eu.solven.cleanthat.code_provider.github.event.ICodeCleanerFactory;
import eu.solven.cleanthat.config.CleanthatConfigInitializer;
import eu.solven.cleanthat.config.ConfigHelpers;
import eu.solven.cleanthat.config.ICleanthatConfigInitializer;
import eu.solven.cleanthat.config.spring.ConfigSpringConfig;
import eu.solven.cleanthat.engine.ICodeFormatterApplier;
import eu.solven.cleanthat.engine.IEngineFormatterFactory;
import eu.solven.cleanthat.engine.IEngineLintFixerFactory;
import eu.solven.cleanthat.engine.StringFormatterFactory;
import eu.solven.cleanthat.formatter.CodeFormatterApplier;
import eu.solven.cleanthat.formatter.CodeProviderFormatter;
import eu.solven.cleanthat.formatter.ICodeProviderFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@Import(value={ConfigSpringConfig.class})
public class CodeCleanerSpringConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeCleanerSpringConfig.class);

    @Bean
    public ICodeFormatterApplier codeFormatterApplier() {
        return new CodeFormatterApplier();
    }

    @Bean
    public IEngineFormatterFactory stringFormatterFactory(List<IEngineLintFixerFactory> stringFormatters) {
        LinkedHashMap<String, IEngineLintFixerFactory> asMap = new LinkedHashMap<String, IEngineLintFixerFactory>();
        stringFormatters.forEach(sf -> {
            String language = sf.getEngine();
            LOGGER.info("Formatter registered for engine={}: {}", (Object)language, sf);
            asMap.put(language, (IEngineLintFixerFactory)sf);
        });
        return new StringFormatterFactory(asMap);
    }

    @Bean
    public ICleanthatConfigInitializer configInitializer(ConfigHelpers configHelpers, List<IEngineLintFixerFactory> factories) {
        List<IEngineLintFixerFactory> cleanFactories = factories.stream().filter(f -> !"openrewrite".equals(f.getEngine())).collect(Collectors.toList());
        if (cleanFactories.size() != factories.size()) {
            LOGGER.info("We disabled {} as engine in configInitializer", (Object)"openrewrite");
        }
        return new CleanthatConfigInitializer(configHelpers.getObjectMapper(), cleanFactories);
    }

    @Bean
    public ICodeProviderFormatter codeProviderFormatter(ConfigHelpers configHelpers, IEngineFormatterFactory formatterFactory, ICodeFormatterApplier formatterApplier) {
        return new CodeProviderFormatter(configHelpers, formatterFactory, formatterApplier);
    }

    @Bean
    @Primary
    public ICodeCleanerFactory compositeCodeCleanerFactory(List<ICodeCleanerFactory> specialized) {
        return new CompositeCodeCleanerFactory(specialized);
    }
}

