/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.tools.resolvers.github;

import jadx.core.utils.ListUtils;
import jadx.plugins.tools.data.JadxPluginMetadata;
import jadx.plugins.tools.resolvers.IJadxPluginResolver;
import jadx.plugins.tools.resolvers.github.GithubTools;
import jadx.plugins.tools.resolvers.github.LocationInfo;
import jadx.plugins.tools.resolvers.github.data.Asset;
import jadx.plugins.tools.resolvers.github.data.Release;
import jadx.plugins.tools.utils.PluginUtils;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GithubReleaseResolver
implements IJadxPluginResolver {
    private static final Pattern VERSION_PATTERN = Pattern.compile("v?\\d+\\.\\d+(\\.\\d+)?");

    @Override
    public Optional<JadxPluginMetadata> resolve(String locationId) {
        LocationInfo info = GithubReleaseResolver.parseLocation(locationId);
        if (info == null) {
            return Optional.empty();
        }
        Release release = GithubTools.fetchRelease(info);
        JadxPluginMetadata metadata = this.buildMetadata(release, info);
        return Optional.of(metadata);
    }

    @Override
    public List<JadxPluginMetadata> resolveVersions(String locationId, int page, int perPage) {
        LocationInfo info = GithubReleaseResolver.parseLocation(locationId);
        if (info == null) {
            return List.of();
        }
        return GithubTools.fetchReleases(info, page, perPage).stream().map(r -> this.buildMetadata((Release)r, info)).collect(Collectors.toList());
    }

    @Override
    public boolean hasVersion(String locationId) {
        LocationInfo locationInfo = GithubReleaseResolver.parseLocation(locationId);
        return locationInfo != null && locationInfo.getVersion() != null;
    }

    private JadxPluginMetadata buildMetadata(Release release, LocationInfo info) {
        String assetVersion;
        List<Asset> assets = release.getAssets();
        String releaseVersion = PluginUtils.removePrefix(release.getName(), "v");
        Asset asset = GithubReleaseResolver.searchPluginAsset(assets, info.getArtifactPrefix(), releaseVersion);
        if (!asset.getName().contains(releaseVersion) && (assetVersion = PluginUtils.extractVersion(asset.getName())) != null) {
            releaseVersion = assetVersion;
        }
        JadxPluginMetadata metadata = new JadxPluginMetadata();
        metadata.setVersion(releaseVersion);
        metadata.setLocationId(GithubReleaseResolver.buildLocationIdWithoutVersion(info));
        metadata.setJar(asset.getDownloadUrl());
        return metadata;
    }

    private static LocationInfo parseLocation(String locationId) {
        if (!locationId.startsWith("github:")) {
            return null;
        }
        String[] parts = locationId.split(":");
        if (parts.length < 3) {
            return null;
        }
        String owner = parts[1];
        String project = parts[2];
        String version = null;
        String artifactPrefix = project;
        if (parts.length >= 4) {
            String part = parts[3];
            if (VERSION_PATTERN.matcher(part).matches()) {
                version = part;
                if (parts.length >= 5) {
                    artifactPrefix = parts[4];
                }
            } else {
                artifactPrefix = part;
            }
        }
        return new LocationInfo(owner, project, artifactPrefix, version);
    }

    private static Asset searchPluginAsset(List<Asset> assets, String artifactPrefix, String releaseVersion) {
        String artifactName = artifactPrefix + "-" + releaseVersion + ".jar";
        Asset exactAsset = (Asset)ListUtils.filterOnlyOne(assets, a -> a.getName().equals(artifactName));
        if (exactAsset != null) {
            return exactAsset;
        }
        Asset foundAsset = (Asset)ListUtils.filterOnlyOne(assets, a -> {
            String assetFileName = a.getName();
            return assetFileName.startsWith(artifactPrefix) && assetFileName.endsWith(".jar");
        });
        if (foundAsset != null) {
            return foundAsset;
        }
        throw new RuntimeException("Release artifact with prefix '" + artifactPrefix + "' not found");
    }

    private static String buildLocationIdWithoutVersion(LocationInfo info) {
        String baseLocation = "github:" + info.getOwner() + ":" + info.getProject();
        if (info.getProject().equals(info.getArtifactPrefix())) {
            return baseLocation;
        }
        return baseLocation + ":" + info.getArtifactPrefix();
    }

    @Override
    public String id() {
        return "github";
    }

    @Override
    public boolean isUpdateSupported() {
        return true;
    }
}

