/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.tools.resolvers.file;

import jadx.plugins.tools.data.JadxPluginMetadata;
import jadx.plugins.tools.resolvers.IJadxPluginResolver;
import jadx.plugins.tools.utils.PluginUtils;
import java.io.File;
import java.util.Optional;

public class LocalFileResolver
implements IJadxPluginResolver {
    @Override
    public String id() {
        return "file";
    }

    @Override
    public boolean isUpdateSupported() {
        return false;
    }

    @Override
    public Optional<JadxPluginMetadata> resolve(String locationId) {
        if (!locationId.startsWith("file:") || !locationId.endsWith(".jar")) {
            return Optional.empty();
        }
        File jarFile = new File(PluginUtils.removePrefix(locationId, "file:"));
        if (!jarFile.isFile()) {
            throw new RuntimeException("File not found: " + jarFile.getAbsolutePath());
        }
        JadxPluginMetadata metadata = new JadxPluginMetadata();
        metadata.setLocationId(locationId);
        metadata.setResolverId(this.id());
        metadata.setJar(jarFile.getAbsolutePath());
        return Optional.of(metadata);
    }
}

