/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.utils;

import jadx.plugins.input.java.utils.JavaClassParseException;
import java.nio.charset.StandardCharsets;

public class ModifiedUTF8Decoder {
    public static String decodeString(byte[] bytes) {
        int len = bytes.length;
        boolean asciiStr = true;
        for (byte b : bytes) {
            if ((b & 0x80) == 0) continue;
            asciiStr = false;
            break;
        }
        if (asciiStr) {
            return new String(bytes, StandardCharsets.US_ASCII);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int x = bytes[i] & 0xFF;
            if ((x & 0x80) == 0) {
                sb.append((char)x);
                continue;
            }
            if (i + 1 >= len) {
                throw new JavaClassParseException("Inconsistent byte array structure: too short");
            }
            int y = bytes[i + 1] & 0xFF;
            if (x == 192 && y == 128) {
                sb.appendCodePoint(0);
                ++i;
                continue;
            }
            if ((x & 0xE0) == 192 && (y & 0xC0) == 128) {
                sb.appendCodePoint(((x & 0x1F) << 6) + (y & 0x3F));
                ++i;
                continue;
            }
            if (i + 2 >= len) continue;
            int z = bytes[i + 2] & 0xFF;
            if ((x & 0xF0) == 224 && (y & 0xC0) == 128 && (z & 0xC0) == 128) {
                sb.appendCodePoint(((x & 0xF) << 12) + ((y & 0x3F) << 6) + (z & 0x3F));
                i += 2;
                continue;
            }
            if (i + 5 < len && x == 237 && (y & 0xF0) == 160 && (bytes[i + 3] & 0xFF) == 237 && (bytes[i + 4] & 0xF0) == 160) {
                int u = x;
                int v = y;
                int w = z;
                x = bytes[i + 3] & 0xFF;
                y = bytes[i + 4] & 0xFF;
                z = bytes[i + 5] & 0xFF;
                if (x == 237 && (y & 0xF0) == 160) {
                    sb.appendCodePoint(65536 + ((v & 0xF) << 16) + ((w & 0x3F) << 10) + ((y & 0xF) << 6) + (z & 0x3F));
                    i += 5;
                    continue;
                }
                throw new JavaClassParseException("Inconsistent byte array structure: invalid 6 bytes char");
            }
            throw new JavaClassParseException("Inconsistent byte array structure: unexpected char");
        }
        return sb.toString();
    }
}

