/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.code;

import jadx.api.plugins.input.insns.Opcode;
import jadx.plugins.input.java.data.DataReader;
import jadx.plugins.input.java.data.JavaClassData;
import jadx.plugins.input.java.data.code.JavaInsnData;
import jadx.plugins.input.java.data.code.StackState;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CodeDecodeState {
    private final JavaClassData clsData;
    private final DataReader reader;
    private final int maxStack;
    private final Set<Integer> excHandlers;
    private final Map<Integer, StackState> jumpStack = new HashMap<Integer, StackState>();
    private JavaInsnData insn;
    private StackState stack;
    private boolean excHandler;

    public CodeDecodeState(JavaClassData clsData, DataReader reader, int maxStack, Set<Integer> excHandlers) {
        this.clsData = clsData;
        this.reader = reader;
        this.maxStack = maxStack;
        this.excHandlers = excHandlers;
        this.stack = new StackState(maxStack);
    }

    public void onInsn(int offset) {
        StackState stackState = this.jumpStack.get(offset);
        if (stackState != null) {
            this.stack = stackState;
        }
        if (this.excHandlers.contains(offset)) {
            this.clear();
            this.stack.push(StackState.SVType.NARROW);
            this.excHandler = true;
        } else {
            this.excHandler = false;
        }
    }

    public void registerJump(int jumpOffset) {
        Integer key = jumpOffset;
        if (!this.jumpStack.containsKey(key)) {
            this.jumpStack.put(key, this.stack.copy());
        }
    }

    public void decoded() {
        if (this.excHandler && this.insn.getOpcode() == Opcode.MOVE) {
            this.insn.setOpcode(Opcode.MOVE_EXCEPTION);
            this.insn.setRegsCount(1);
        }
    }

    public JavaInsnData insn() {
        return this.insn;
    }

    public void setInsn(JavaInsnData insn) {
        this.insn = insn;
    }

    public DataReader reader() {
        return this.reader;
    }

    public JavaClassData clsData() {
        return this.clsData;
    }

    public CodeDecodeState local(int arg, int local) {
        this.insn.setArgReg(arg, this.localToReg(local));
        return this;
    }

    public CodeDecodeState pop(int arg) {
        this.insn.setArgReg(arg, this.stack.pop());
        return this;
    }

    public CodeDecodeState peek(int arg) {
        this.insn.setArgReg(arg, this.stack.peek());
        return this;
    }

    public StackState.SVType peekType(int at) {
        return this.stack.peekTypeAt(at);
    }

    public CodeDecodeState peekFrom(int pos, int arg) {
        this.insn.setArgReg(arg, this.stack.peekAt(pos));
        return this;
    }

    public CodeDecodeState push(int arg) {
        this.insn.setArgReg(arg, this.stack.push(StackState.SVType.NARROW));
        return this;
    }

    public CodeDecodeState push(int arg, StackState.SVType type) {
        this.insn.setArgReg(arg, this.stack.push(type));
        return this;
    }

    public CodeDecodeState pushWide(int arg) {
        this.insn.setArgReg(arg, this.stack.push(StackState.SVType.WIDE));
        return this;
    }

    public int insert(int pos, StackState.SVType type) {
        return this.stack.insert(pos, type);
    }

    public void discard() {
        this.stack.pop();
    }

    public void discardWord() {
        StackState.SVType type = this.stack.peekTypeAt(0);
        this.stack.pop();
        if (type == StackState.SVType.NARROW) {
            this.stack.pop();
        }
    }

    public CodeDecodeState clear() {
        this.stack.clear();
        return this;
    }

    public int push(String type) {
        return this.stack.push(this.getSVType(type));
    }

    public void jump(int offset) {
        int jumpOffset = this.insn.getOffset() + offset;
        this.insn.setTarget(jumpOffset);
        this.registerJump(jumpOffset);
    }

    public CodeDecodeState idx(int idx) {
        this.insn.setIndex(idx);
        return this;
    }

    public CodeDecodeState lit(long lit) {
        this.insn.setLiteral(lit);
        return this;
    }

    private int localToReg(int local) {
        return this.maxStack + local;
    }

    public StackState.SVType fieldType() {
        String type = this.insn.constPoolReader().getFieldType(this.insn().getIndex());
        return this.getSVType(type);
    }

    public StackState.SVType getSVType(String type) {
        if (type.equals("J") || type.equals("D")) {
            return StackState.SVType.WIDE;
        }
        return StackState.SVType.NARROW;
    }

    public int u1() {
        return this.reader.readU1();
    }

    public int u2() {
        return this.reader.readU2();
    }

    public int s1() {
        return this.reader.readS1();
    }

    public int s2() {
        return this.reader.readS2();
    }
}

