/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections;

import jadx.plugins.input.dex.utils.DataReader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DexHeaderV41 {
    private final int fileSize;
    private final int containerSize;
    private final int headerOffset;

    @Nullable
    public static DexHeaderV41 readIfPresent(byte[] content) {
        int headerSize = DataReader.readU4(content, 36);
        if (headerSize < 120) {
            return null;
        }
        int fileSize = DataReader.readU4(content, 32);
        int containerSize = DataReader.readU4(content, 112);
        int headerOffset = DataReader.readU4(content, 116);
        return new DexHeaderV41(fileSize, containerSize, headerOffset);
    }

    public static List<Integer> readSubDexOffsets(byte[] content, DexHeaderV41 header) {
        int start = 0;
        int end = header.getFileSize();
        int limit = Math.min(header.getContainerSize(), content.length);
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (true) {
            list.add(start);
            start = end;
            if (start >= limit) break;
            int nextFileSize = DataReader.readU4(content, start + 32);
            end = start + nextFileSize;
        }
        return list;
    }

    public DexHeaderV41(int fileSize, int containerSize, int headerOffset) {
        this.fileSize = fileSize;
        this.containerSize = containerSize;
        this.headerOffset = headerOffset;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public int getContainerSize() {
        return this.containerSize;
    }

    public int getHeaderOffset() {
        return this.headerOffset;
    }
}

