/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex;

import jadx.api.plugins.utils.CommonFileUtils;
import jadx.core.utils.files.FileUtils;
import jadx.plugins.input.dex.DexInputOptions;
import jadx.plugins.input.dex.DexReader;
import jadx.plugins.input.dex.sections.DexConsts;
import jadx.plugins.input.dex.sections.DexHeaderV41;
import jadx.plugins.input.dex.utils.DexCheckSum;
import jadx.zip.IZipEntry;
import jadx.zip.ZipContent;
import jadx.zip.ZipReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DexFileLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DexFileLoader.class);
    private static int dexUniqId = 1;
    private final DexInputOptions options;
    private ZipReader zipReader = new ZipReader();

    public DexFileLoader(DexInputOptions options) {
        this.options = options;
    }

    public void setZipReader(ZipReader zipReader) {
        this.zipReader = zipReader;
    }

    public List<DexReader> collectDexFiles(List<Path> pathsList) {
        return pathsList.stream().map(Path::toFile).map(this::loadDexFromFile).filter(list -> !list.isEmpty()).flatMap(Collection::stream).peek(dr -> LOG.debug("Loading dex: {}", dr)).collect(Collectors.toList());
    }

    private List<DexReader> loadDexFromFile(File file) {
        List<DexReader> list;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            list = this.load(file, inputStream, file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.error("File open error: {}", (Object)file.getAbsolutePath(), (Object)e);
                return Collections.emptyList();
            }
        }
        ((InputStream)inputStream).close();
        return list;
    }

    private List<DexReader> load(@Nullable File file, InputStream inputStream, String fileName) throws IOException {
        try (InputStream in = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);){
            List<DexReader> list;
            byte[] magic = new byte[4];
            in.mark(magic.length);
            if (in.read(magic) != magic.length) {
                List<DexReader> list2 = Collections.emptyList();
                return list2;
            }
            if (DexFileLoader.isStartWithBytes(magic, DexConsts.DEX_FILE_MAGIC)) {
                in.reset();
                byte[] content = DexFileLoader.readAllBytes(in);
                List<DexReader> list3 = this.loadDexReaders(fileName, content);
                return list3;
            }
            if (fileName.endsWith(".dex")) {
                String hex = FileUtils.bytesToHex((byte[])magic);
                String str = new String(magic, StandardCharsets.US_ASCII);
                LOG.warn("Invalid DEX magic: 0x{}(\"{}\") in file: {}", new Object[]{hex, str, fileName});
            }
            if (file != null && (DexFileLoader.isStartWithBytes(magic, DexConsts.ZIP_FILE_MAGIC) || CommonFileUtils.isZipFileExt((String)fileName))) {
                list = this.collectDexFromZip(file);
                return list;
            }
            list = Collections.emptyList();
            return list;
        }
    }

    private List<DexReader> loadFromZipEntry(byte[] content, String fileName) {
        if (DexFileLoader.isStartWithBytes(content, DexConsts.DEX_FILE_MAGIC) || fileName.endsWith(".dex")) {
            return this.loadDexReaders(fileName, content);
        }
        return Collections.emptyList();
    }

    public List<DexReader> loadDexReaders(String fileName, byte[] content) {
        DexHeaderV41 dexHeaderV41 = DexHeaderV41.readIfPresent(content);
        if (dexHeaderV41 != null) {
            return DexHeaderV41.readSubDexOffsets(content, dexHeaderV41).stream().map(offset -> this.loadSingleDex(fileName, content, (int)offset)).collect(Collectors.toList());
        }
        DexReader dexReader = this.loadSingleDex(fileName, content, 0);
        return Collections.singletonList(dexReader);
    }

    private DexReader loadSingleDex(String fileName, byte[] content, int offset) {
        if (this.options.isVerifyChecksum()) {
            DexCheckSum.verify(fileName, content, offset);
        }
        return new DexReader(DexFileLoader.getNextUniqId(), fileName, content, offset);
    }

    @Deprecated
    public DexReader loadDexReader(String fileName, byte[] content) {
        return this.loadSingleDex(fileName, content, 0);
    }

    private List<DexReader> collectDexFromZip(File file) {
        ArrayList<DexReader> result = new ArrayList<DexReader>();
        try (ZipContent zip = this.zipReader.open(file);){
            for (IZipEntry entry : zip.getEntries()) {
                if (entry.isDirectory()) continue;
                try {
                    List<DexReader> readers = entry.preferBytes() ? this.loadFromZipEntry(entry.getBytes(), entry.getName()) : this.load(null, entry.getInputStream(), entry.getName());
                    if (readers.isEmpty()) continue;
                    result.addAll(readers);
                }
                catch (Exception e) {
                    LOG.error("Failed to read zip entry: {}", (Object)entry, (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to process zip file: {}", (Object)file.getAbsolutePath(), (Object)e);
        }
        return result;
    }

    private static boolean isStartWithBytes(byte[] fileMagic, byte[] expectedBytes) {
        int len = expectedBytes.length;
        if (fileMagic.length < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (fileMagic[i] == expectedBytes[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] readAllBytes(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((read = in.read(data)) != -1) {
            buf.write(data, 0, read);
        }
        return buf.toByteArray();
    }

    private static synchronized int getNextUniqId() {
        if (++dexUniqId >= 65535) {
            dexUniqId = 1;
        }
        return dexUniqId;
    }

    private static synchronized void resetDexUniqId() {
        dexUniqId = 1;
    }
}

