/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections;

import jadx.api.plugins.input.data.annotations.AnnotationVisibility;
import jadx.api.plugins.input.data.annotations.EncodedType;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.input.data.attributes.types.AnnotationDefaultClassAttr;
import jadx.api.plugins.input.data.attributes.types.AnnotationsAttr;
import jadx.api.plugins.input.data.attributes.types.ExceptionsAttr;
import jadx.api.plugins.input.data.attributes.types.InnerClassesAttr;
import jadx.api.plugins.input.data.attributes.types.InnerClsInfo;
import jadx.api.plugins.input.data.attributes.types.SignatureAttr;
import jadx.api.plugins.utils.Utils;
import jadx.plugins.input.dex.sections.annotations.AnnotationsUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DexAnnotationsConvert {
    private static final Logger LOG = LoggerFactory.getLogger(DexAnnotationsConvert.class);

    public static void forClass(String cls, List<IJadxAttribute> list, List<IAnnotation> annotationList) {
        DexAnnotationsConvert.appendAnnotations(cls, list, annotationList);
    }

    public static void forMethod(List<IJadxAttribute> list, List<IAnnotation> annotationList) {
        DexAnnotationsConvert.appendAnnotations(null, list, annotationList);
    }

    public static void forField(List<IJadxAttribute> list, List<IAnnotation> annotationList) {
        DexAnnotationsConvert.appendAnnotations(null, list, annotationList);
    }

    private static void appendAnnotations(String cls, List<IJadxAttribute> attributes, List<IAnnotation> annotations) {
        if (annotations.isEmpty()) {
            return;
        }
        for (IAnnotation annotation : annotations) {
            if (annotation.getVisibility() != AnnotationVisibility.SYSTEM) continue;
            DexAnnotationsConvert.convertSystemAnnotations(cls, attributes, annotation);
        }
        Utils.addToList(attributes, (Object)AnnotationsAttr.pack(annotations));
    }

    private static void convertSystemAnnotations(String cls, List<IJadxAttribute> attributes, IAnnotation annotation) {
        switch (annotation.getAnnotationClass()) {
            case "Ldalvik/annotation/Signature;": {
                attributes.add((IJadxAttribute)new SignatureAttr(DexAnnotationsConvert.extractSignature(annotation)));
                break;
            }
            case "Ldalvik/annotation/InnerClass;": {
                try {
                    String name = AnnotationsUtils.getValue(annotation, "name", EncodedType.ENCODED_STRING, null);
                    int accFlags = AnnotationsUtils.getValue(annotation, "accessFlags", EncodedType.ENCODED_INT, 0);
                    if (name == null && accFlags == 0) break;
                    InnerClsInfo innerClsInfo = new InnerClsInfo(cls, null, name, accFlags);
                    attributes.add((IJadxAttribute)new InnerClassesAttr(Collections.singletonMap(cls, innerClsInfo)));
                }
                catch (Exception e) {
                    LOG.warn("Failed to parse annotation: " + annotation, (Throwable)e);
                }
                break;
            }
            case "Ldalvik/annotation/AnnotationDefault;": {
                EncodedValue annValue = annotation.getDefaultValue();
                if (annValue == null || annValue.getType() != EncodedType.ENCODED_ANNOTATION) break;
                IAnnotation defAnnotation = (IAnnotation)annValue.getValue();
                attributes.add((IJadxAttribute)new AnnotationDefaultClassAttr(defAnnotation.getValues()));
                break;
            }
            case "Ldalvik/annotation/Throws;": {
                try {
                    EncodedValue defaultValue = annotation.getDefaultValue();
                    if (defaultValue == null) break;
                    List excs = ((List)defaultValue.getValue()).stream().map(ev -> (String)ev.getValue()).collect(Collectors.toList());
                    attributes.add((IJadxAttribute)new ExceptionsAttr(excs));
                    break;
                }
                catch (Exception e) {
                    LOG.warn("Failed to convert dalvik throws annotation", (Throwable)e);
                }
            }
        }
    }

    private static String extractSignature(IAnnotation annotation) {
        List values = (List)annotation.getDefaultValue().getValue();
        if (values.size() == 1) {
            return (String)((EncodedValue)values.get(0)).getValue();
        }
        StringBuilder sb = new StringBuilder();
        for (EncodedValue part : values) {
            sb.append((String)part.getValue());
        }
        return sb.toString();
    }
}

