/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import jadx.api.ICodeCache;
import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.impl.AnnotatedCodeWriter;
import jadx.api.impl.NoOpCodeCache;
import jadx.api.impl.SimpleCodeWriter;
import jadx.api.plugins.loader.JadxPluginLoader;
import jadx.api.security.IJadxSecurity;
import jadx.api.security.JadxSecurityFlag;
import jadx.api.security.impl.JadxSecurity;
import jadx.cli.JadxCLIArgs;
import jadx.cli.LogHelper;
import jadx.cli.SingleClassMode;
import jadx.cli.plugins.JadxFilesGetter;
import jadx.commons.app.JadxCommonEnv;
import jadx.core.plugins.files.IJadxFilesGetter;
import jadx.core.utils.exceptions.JadxArgsValidateException;
import jadx.plugins.tools.JadxExternalPluginsLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxCLI {
    private static final Logger LOG = LoggerFactory.getLogger(JadxCLI.class);

    public static void main(String[] args) {
        int result = 1;
        try {
            result = JadxCLI.execute(args);
        }
        finally {
            System.exit(result);
        }
    }

    public static int execute(String[] args) {
        try {
            JadxCLIArgs jadxArgs = new JadxCLIArgs();
            if (jadxArgs.processArgs(args)) {
                return JadxCLI.processAndSave(jadxArgs);
            }
            return 0;
        }
        catch (JadxArgsValidateException e) {
            LOG.error("Incorrect arguments: {}", (Object)e.getMessage());
            return 1;
        }
        catch (Throwable e) {
            LOG.error("Process error:", e);
            return 1;
        }
    }

    private static int processAndSave(JadxCLIArgs cliArgs) {
        LogHelper.initLogLevel(cliArgs);
        LogHelper.setLogLevelsForLoadingStage();
        JadxArgs jadxArgs = cliArgs.toJadxArgs();
        jadxArgs.setCodeCache((ICodeCache)new NoOpCodeCache());
        jadxArgs.setPluginLoader((JadxPluginLoader)new JadxExternalPluginsLoader());
        jadxArgs.setFilesGetter((IJadxFilesGetter)JadxFilesGetter.INSTANCE);
        JadxCLI.initCodeWriterProvider(jadxArgs);
        JadxCLI.applyEnvVars(jadxArgs);
        try (JadxDecompiler jadx = new JadxDecompiler(jadxArgs);){
            int errorsCount;
            jadx.load();
            if (JadxCLI.checkForErrors(jadx)) {
                int n = 1;
                return n;
            }
            LogHelper.setLogLevelsForDecompileStage();
            if (!SingleClassMode.process(jadx, cliArgs)) {
                JadxCLI.save(jadx);
            }
            if ((errorsCount = jadx.getErrorsCount()) != 0) {
                jadx.printErrorsReport();
                LOG.error("finished with errors, count: {}", (Object)errorsCount);
                int n = 1;
                return n;
            }
            LOG.info("done");
            int n = 0;
            return n;
        }
    }

    private static void initCodeWriterProvider(JadxArgs jadxArgs) {
        switch (jadxArgs.getOutputFormat()) {
            case JAVA: {
                jadxArgs.setCodeWriterProvider(SimpleCodeWriter::new);
                break;
            }
            case JSON: {
                jadxArgs.setCodeWriterProvider(AnnotatedCodeWriter::new);
            }
        }
    }

    private static void applyEnvVars(JadxArgs jadxArgs) {
        Set flags = JadxSecurityFlag.all();
        boolean modified = false;
        boolean disableXmlSecurity = JadxCommonEnv.getBool((String)"JADX_DISABLE_XML_SECURITY", (boolean)false);
        if (disableXmlSecurity) {
            flags.remove(JadxSecurityFlag.SECURE_XML_PARSER);
            flags.remove(JadxSecurityFlag.VERIFY_APP_PACKAGE);
            modified = true;
        }
        if (modified) {
            jadxArgs.setSecurity((IJadxSecurity)new JadxSecurity(flags));
        }
    }

    private static boolean checkForErrors(JadxDecompiler jadx) {
        if (jadx.getRoot().getClasses().isEmpty()) {
            if (jadx.getArgs().isSkipResources()) {
                LOG.error("Load failed! No classes for decompile!");
                return true;
            }
            if (!jadx.getArgs().isSkipSources()) {
                LOG.warn("No classes to decompile; decoding resources only");
                jadx.getArgs().setSkipSources(true);
            }
        }
        if (jadx.getErrorsCount() > 0) {
            LOG.error("Load with errors! Check log for details");
            return false;
        }
        return false;
    }

    private static void save(JadxDecompiler jadx) {
        if (LogHelper.getLogLevel() == LogHelper.LogLevelEnum.QUIET) {
            jadx.save();
        } else {
            LOG.info("processing ...");
            jadx.save(500, (done, total) -> {
                int progress = (int)((double)done * 100.0 / (double)total);
                System.out.printf("INFO  - progress: %d of %d (%d%%)\r", done, total, progress);
            });
            System.out.print("                                                             \r");
        }
    }
}

