/*
 * Decompiled with CFR 0.152.
 */
package io.github.sharelison.jsontojava;

import io.github.sharelison.jsontojava.converter.JsonClassResult;
import io.github.sharelison.jsontojava.converter.JsonConverter;
import io.github.sharelison.jsontojava.converter.factory.JsonConverterFactory;
import io.github.sharelison.jsontojava.exception.JsonToJavaException;
import io.github.sharelison.jsontojava.file.FileReader;
import io.github.sharelison.jsontojava.file.FileSaver;
import io.github.sharelison.jsontojava.file.JavaFileSaver;
import io.github.sharelison.jsontojava.file.JsonFileReader;
import io.github.sharelison.jsontojava.validator.InputJsonValidator;
import io.github.sharelison.jsontojava.validator.JsonType;
import io.github.sharelison.jsontojava.validator.JsonTypeChecker;
import io.github.sharelison.jsontojava.validator.JsonValidator;
import java.util.List;

public class JsonToJava {
    private final JsonConverterFactory jsonConverterFactory;
    private final FileSaver fileSaver;
    private JsonConverter jsonConverter;

    public JsonToJava() {
        this.jsonConverterFactory = new JsonConverterFactory(new JsonFileReader(), new InputJsonValidator(new JsonType()), new JsonType());
        this.fileSaver = new JavaFileSaver();
    }

    public JsonToJava(FileReader fileReader, JsonValidator jsonValidator, JsonTypeChecker typeChecker, FileSaver fileSaver) {
        this.jsonConverterFactory = new JsonConverterFactory(fileReader, jsonValidator, typeChecker);
        this.fileSaver = fileSaver;
    }

    public JsonToJava(FileReader fileReader, JsonValidator jsonValidator, JsonTypeChecker jsonTypeChecker) {
        this.jsonConverterFactory = new JsonConverterFactory(fileReader, jsonValidator, jsonTypeChecker);
        this.fileSaver = null;
    }

    public void jsonToJava(String json, String objectName, String packageName, String outputDir) {
        this.jsonToJava(json, objectName, packageName, outputDir, true);
    }

    public List<JsonClassResult> jsonToJava(String json, String objectName, String packageName) {
        return this.jsonToJava(json, objectName, packageName, true);
    }

    public void jsonToJava(String json, String objectName, String packageName, String outputDir, boolean withAnnotations) {
        this.initializeJsonConverter(json);
        List<JsonClassResult> javaClassResult = this.jsonConverter.convertToJava(json, objectName, packageName, withAnnotations);
        if (this.fileSaver == null) {
            throw new JsonToJavaException("No instance of FileSaver found");
        }
        javaClassResult.parallelStream().forEach(classResult -> this.fileSaver.saveJavaFile(classResult.getClassDeclaration(), classResult.getClassName(), outputDir));
    }

    public List<JsonClassResult> jsonToJava(String json, String objectName, String packageName, boolean withAnnotations) {
        this.initializeJsonConverter(json);
        return this.jsonConverter.convertToJava(json, objectName, packageName, withAnnotations);
    }

    private synchronized void initializeJsonConverter(String json) {
        if (this.jsonConverter == null) {
            this.jsonConverter = this.jsonConverterFactory.createJsonConverter(json);
        }
    }
}

