/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smart.refresh.classics;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.scwang.smart.drawable.PaintDrawable;
import com.scwang.smart.refresh.footer.classics.R;
import com.scwang.smart.refresh.layout.api.RefreshComponent;
import com.scwang.smart.refresh.layout.api.RefreshKernel;
import com.scwang.smart.refresh.layout.api.RefreshLayout;
import com.scwang.smart.refresh.layout.constant.SpinnerStyle;
import com.scwang.smart.refresh.layout.simple.SimpleComponent;
import com.scwang.smart.refresh.layout.util.SmartUtil;

public abstract class ClassicsAbstract<T extends ClassicsAbstract<?>>
extends SimpleComponent
implements RefreshComponent {
    public static final int ID_TEXT_TITLE = R.id.srl_classics_title;
    public static final int ID_IMAGE_ARROW = R.id.srl_classics_arrow;
    public static final int ID_IMAGE_PROGRESS = R.id.srl_classics_progress;
    protected TextView mTitleText;
    protected ImageView mArrowView;
    protected ImageView mProgressView;
    protected RefreshKernel mRefreshKernel;
    protected PaintDrawable mArrowDrawable;
    protected PaintDrawable mProgressDrawable;
    protected boolean mSetAccentColor;
    protected boolean mSetPrimaryColor;
    protected int mBackgroundColor;
    protected int mFinishDuration = 500;
    protected int mPaddingTop = 20;
    protected int mPaddingBottom = 20;
    protected int mMinHeightOfContent = 0;

    public ClassicsAbstract(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mSpinnerStyle = SpinnerStyle.Translate;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ClassicsAbstract thisView = this;
        if (this.mMinHeightOfContent == 0) {
            this.mPaddingTop = thisView.getPaddingTop();
            this.mPaddingBottom = thisView.getPaddingBottom();
            if (this.mPaddingTop == 0 || this.mPaddingBottom == 0) {
                int paddingLeft = thisView.getPaddingLeft();
                int paddingRight = thisView.getPaddingRight();
                this.mPaddingTop = this.mPaddingTop == 0 ? SmartUtil.dp2px((float)20.0f) : this.mPaddingTop;
                this.mPaddingBottom = this.mPaddingBottom == 0 ? SmartUtil.dp2px((float)20.0f) : this.mPaddingBottom;
                thisView.setPadding(paddingLeft, this.mPaddingTop, paddingRight, this.mPaddingBottom);
            }
            ClassicsAbstract thisGroup = this;
            thisGroup.setClipToPadding(false);
        }
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0x40000000) {
            int parentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (parentHeight < this.mMinHeightOfContent) {
                int padding = (parentHeight - this.mMinHeightOfContent) / 2;
                thisView.setPadding(thisView.getPaddingLeft(), padding, thisView.getPaddingRight(), padding);
            } else {
                thisView.setPadding(thisView.getPaddingLeft(), 0, thisView.getPaddingRight(), 0);
            }
        } else {
            thisView.setPadding(thisView.getPaddingLeft(), this.mPaddingTop, thisView.getPaddingRight(), this.mPaddingBottom);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mMinHeightOfContent == 0) {
            ClassicsAbstract thisGroup = this;
            for (int i = 0; i < thisGroup.getChildCount(); ++i) {
                int height = thisGroup.getChildAt(i).getMeasuredHeight();
                if (this.mMinHeightOfContent >= height) continue;
                this.mMinHeightOfContent = height;
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ImageView arrowView = this.mArrowView;
        ImageView progressView = this.mProgressView;
        arrowView.animate().cancel();
        progressView.animate().cancel();
        Drawable drawable = this.mProgressView.getDrawable();
        if (drawable instanceof Animatable && ((Animatable)drawable).isRunning()) {
            ((Animatable)drawable).stop();
        }
    }

    protected T self() {
        return (T)((Object)this);
    }

    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        this.mRefreshKernel = kernel;
        this.mRefreshKernel.requestDrawBackgroundFor((RefreshComponent)this, this.mBackgroundColor);
    }

    public void onStartAnimator(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        ImageView progressView = this.mProgressView;
        if (progressView.getVisibility() != 0) {
            progressView.setVisibility(0);
            Drawable drawable = this.mProgressView.getDrawable();
            if (drawable instanceof Animatable) {
                ((Animatable)drawable).start();
            } else {
                progressView.animate().rotation(36000.0f).setDuration(100000L);
            }
        }
    }

    public void onReleased(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        this.onStartAnimator(refreshLayout, height, maxDragHeight);
    }

    public int onFinish(@NonNull RefreshLayout refreshLayout, boolean success) {
        ImageView progressView = this.mProgressView;
        Drawable drawable = this.mProgressView.getDrawable();
        if (drawable instanceof Animatable) {
            if (((Animatable)drawable).isRunning()) {
                ((Animatable)drawable).stop();
            }
        } else {
            progressView.animate().rotation(0.0f).setDuration(0L);
        }
        progressView.setVisibility(8);
        return this.mFinishDuration;
    }

    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0) {
            ClassicsAbstract thisView = this;
            if (!(thisView.getBackground() instanceof BitmapDrawable) && !this.mSetPrimaryColor) {
                this.setPrimaryColor(colors[0]);
                this.mSetPrimaryColor = false;
            }
            if (!this.mSetAccentColor) {
                if (colors.length > 1) {
                    this.setAccentColor(colors[1]);
                }
                this.mSetAccentColor = false;
            }
        }
    }

    public T setProgressBitmap(Bitmap bitmap) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageBitmap(bitmap);
        return this.self();
    }

    public T setProgressDrawable(Drawable drawable) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageDrawable(drawable);
        return this.self();
    }

    public T setProgressResource(@DrawableRes int resId) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageResource(resId);
        return this.self();
    }

    public T setArrowBitmap(Bitmap bitmap) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageBitmap(bitmap);
        return this.self();
    }

    public T setArrowDrawable(Drawable drawable) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageDrawable(drawable);
        return this.self();
    }

    public T setArrowResource(@DrawableRes int resId) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageResource(resId);
        return this.self();
    }

    public T setSpinnerStyle(SpinnerStyle style) {
        this.mSpinnerStyle = style;
        return this.self();
    }

    public T setPrimaryColor(@ColorInt int primaryColor) {
        this.mSetPrimaryColor = true;
        this.mBackgroundColor = primaryColor;
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestDrawBackgroundFor((RefreshComponent)this, primaryColor);
        }
        return this.self();
    }

    public T setAccentColor(@ColorInt int accentColor) {
        this.mSetAccentColor = true;
        this.mTitleText.setTextColor(accentColor);
        if (this.mArrowDrawable != null) {
            this.mArrowDrawable.setColor(accentColor);
            this.mArrowView.invalidateDrawable((Drawable)this.mArrowDrawable);
        }
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setColor(accentColor);
            this.mProgressView.invalidateDrawable((Drawable)this.mProgressDrawable);
        }
        return this.self();
    }

    public T setPrimaryColorId(@ColorRes int colorId) {
        ClassicsAbstract thisView = this;
        this.setPrimaryColor(ContextCompat.getColor((Context)thisView.getContext(), (int)colorId));
        return this.self();
    }

    public T setAccentColorId(@ColorRes int colorId) {
        ClassicsAbstract thisView = this;
        this.setAccentColor(ContextCompat.getColor((Context)thisView.getContext(), (int)colorId));
        return this.self();
    }

    public T setFinishDuration(int delay) {
        this.mFinishDuration = delay;
        return this.self();
    }

    public T setTextSizeTitle(float size) {
        this.mTitleText.setTextSize(size);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightFor((RefreshComponent)this);
        }
        return this.self();
    }

    public T setTextSizeTitle(int unit, float size) {
        this.mTitleText.setTextSize(unit, size);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightFor((RefreshComponent)this);
        }
        return this.self();
    }

    public T setDrawableMarginRight(float dp) {
        ImageView arrowView = this.mArrowView;
        ImageView progressView = this.mProgressView;
        ViewGroup.MarginLayoutParams lpArrow = (ViewGroup.MarginLayoutParams)arrowView.getLayoutParams();
        ViewGroup.MarginLayoutParams lpProgress = (ViewGroup.MarginLayoutParams)progressView.getLayoutParams();
        lpArrow.rightMargin = lpProgress.rightMargin = SmartUtil.dp2px((float)dp);
        arrowView.setLayoutParams((ViewGroup.LayoutParams)lpArrow);
        progressView.setLayoutParams((ViewGroup.LayoutParams)lpProgress);
        return this.self();
    }

    public T setDrawableMarginRightPx(int px) {
        ViewGroup.MarginLayoutParams lpArrow = (ViewGroup.MarginLayoutParams)this.mArrowView.getLayoutParams();
        ViewGroup.MarginLayoutParams lpProgress = (ViewGroup.MarginLayoutParams)this.mProgressView.getLayoutParams();
        lpArrow.rightMargin = lpProgress.rightMargin = px;
        this.mArrowView.setLayoutParams((ViewGroup.LayoutParams)lpArrow);
        this.mProgressView.setLayoutParams((ViewGroup.LayoutParams)lpProgress);
        return this.self();
    }

    public T setDrawableSize(float dp) {
        ImageView arrowView = this.mArrowView;
        ImageView progressView = this.mProgressView;
        ViewGroup.LayoutParams lpArrow = arrowView.getLayoutParams();
        ViewGroup.LayoutParams lpProgress = progressView.getLayoutParams();
        lpArrow.width = lpProgress.width = SmartUtil.dp2px((float)dp);
        lpArrow.height = lpProgress.height = SmartUtil.dp2px((float)dp);
        arrowView.setLayoutParams(lpArrow);
        progressView.setLayoutParams(lpProgress);
        return this.self();
    }

    public T setDrawableSizePx(int px) {
        ViewGroup.LayoutParams lpArrow = this.mArrowView.getLayoutParams();
        ViewGroup.LayoutParams lpProgress = this.mProgressView.getLayoutParams();
        lpArrow.width = lpProgress.width = px;
        lpArrow.height = lpProgress.height = px;
        this.mArrowView.setLayoutParams(lpArrow);
        this.mProgressView.setLayoutParams(lpProgress);
        return this.self();
    }

    public T setDrawableArrowSize(float dp) {
        ImageView arrowView = this.mArrowView;
        ViewGroup.LayoutParams lpArrow = arrowView.getLayoutParams();
        lpArrow.height = lpArrow.width = SmartUtil.dp2px((float)dp);
        arrowView.setLayoutParams(lpArrow);
        return this.self();
    }

    public T setDrawableArrowSizePx(int px) {
        ViewGroup.LayoutParams lpArrow = this.mArrowView.getLayoutParams();
        lpArrow.width = px;
        lpArrow.height = px;
        this.mArrowView.setLayoutParams(lpArrow);
        return this.self();
    }

    public T setDrawableProgressSize(float dp) {
        ImageView progressView = this.mProgressView;
        ViewGroup.LayoutParams lpProgress = progressView.getLayoutParams();
        lpProgress.height = lpProgress.width = SmartUtil.dp2px((float)dp);
        progressView.setLayoutParams(lpProgress);
        return this.self();
    }

    public T setDrawableProgressSizePx(int px) {
        ViewGroup.LayoutParams lpProgress = this.mProgressView.getLayoutParams();
        lpProgress.width = px;
        lpProgress.height = px;
        this.mProgressView.setLayoutParams(lpProgress);
        return this.self();
    }
}

