/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.slimvalidator.validators;

import io.github.sashirestela.slimvalidator.ConstraintValidator;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.validators.ObjectTypeValidator;

public class ObjectTypesValidator
implements ConstraintValidator<ObjectType.ObjectTypes, Object> {
    public static final String MSG_PREFIX = "type must be one of ";
    public static final String MSG_POSTFIX = ".";
    private ObjectType[] objectTypeList;

    @Override
    public void initialize(ObjectType.ObjectTypes annotation) {
        this.objectTypeList = (ObjectType[])annotation.value().clone();
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder(MSG_PREFIX);
        ObjectTypeValidator itemValidator = new ObjectTypeValidator();
        String itemMessage = "";
        for (int i = 0; i < this.objectTypeList.length; ++i) {
            itemValidator.initialize(this.objectTypeList[i]);
            itemMessage = itemValidator.getMessage().replace(MSG_PREFIX, "");
            itemMessage = itemMessage.replace(MSG_POSTFIX, "");
            message.append(itemMessage);
            if (i < this.objectTypeList.length - 1) {
                message.append(" or ");
                continue;
            }
            message.append(MSG_POSTFIX);
        }
        return message.toString();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        ObjectTypeValidator itemValidator = new ObjectTypeValidator();
        for (ObjectType objectType : this.objectTypeList) {
            itemValidator.initialize(objectType);
            if (!itemValidator.isValid(value)) continue;
            return true;
        }
        return false;
    }
}

