/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.slimvalidator.metadata;

import io.github.sashirestela.slimvalidator.Constraint;
import io.github.sashirestela.slimvalidator.ConstraintValidator;
import io.github.sashirestela.slimvalidator.Valid;
import io.github.sashirestela.slimvalidator.metadata.ClassMetadata;
import io.github.sashirestela.slimvalidator.util.Common;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataStore.class);
    private static MetadataStore store = null;
    private Map<String, ClassMetadata> classesByFullName = new ConcurrentHashMap<String, ClassMetadata>();

    private MetadataStore() {
    }

    public static MetadataStore one() {
        if (store == null) {
            store = new MetadataStore();
        }
        return store;
    }

    public ClassMetadata get(Class<?> clazz) {
        String className = clazz.getName();
        if (!this.classesByFullName.containsKey(className)) {
            this.save(clazz);
        }
        return this.classesByFullName.get(className);
    }

    private void save(Class<?> clazz) {
        ArrayList<ClassMetadata.FieldMetadata> fields = new ArrayList<ClassMetadata.FieldMetadata>();
        for (Field javaField : this.getFullFields(clazz)) {
            List<ClassMetadata.AnnotationMetadata> annotations = this.getContraintAnnotations(javaField.getDeclaredAnnotations());
            if (annotations.isEmpty()) continue;
            ClassMetadata.FieldMetadata fieldMetadata = ClassMetadata.FieldMetadata.builder().name(javaField.getName()).annotations(annotations).build();
            fields.add(fieldMetadata);
        }
        List<ClassMetadata.AnnotationMetadata> annotations = this.getContraintAnnotations(clazz.getDeclaredAnnotations());
        ClassMetadata classMetadata = ClassMetadata.builder().fullName(clazz.getName()).annotations(annotations).fields(fields).build();
        this.classesByFullName.put(clazz.getName(), classMetadata);
        log.debug("The class {} was saved", (Object)clazz.getSimpleName());
    }

    private Field[] getFullFields(Class<?> clazz) {
        Field[] fullFields = clazz.getDeclaredFields();
        for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
            fullFields = Common.concatArrays(superClazz.getDeclaredFields(), fullFields);
        }
        return fullFields;
    }

    private List<ClassMetadata.AnnotationMetadata> getContraintAnnotations(Annotation[] javaAnnotations) {
        ArrayList<ClassMetadata.AnnotationMetadata> annotations = new ArrayList<ClassMetadata.AnnotationMetadata>();
        for (Annotation javaAnnotation : javaAnnotations) {
            Class<? extends Annotation> javaAnnotationType = javaAnnotation.annotationType();
            if (!javaAnnotationType.isAnnotationPresent(Constraint.class) && !(javaAnnotation instanceof Valid)) continue;
            ConcurrentHashMap<String, Object> valuesByAnnotMethod = new ConcurrentHashMap<String, Object>();
            List<ClassMetadata.AnnotationMetadata> subAnnotations = null;
            for (Method javaAnnotMethod : javaAnnotationType.getDeclaredMethods()) {
                Annotation[] value;
                try {
                    value = javaAnnotMethod.invoke((Object)javaAnnotation, (Object[])null);
                }
                catch (Exception e) {
                    value = null;
                }
                if (value instanceof Annotation[]) {
                    subAnnotations = this.getContraintAnnotations(value);
                    value = new Annotation[]{};
                }
                valuesByAnnotMethod.put(javaAnnotMethod.getName(), value);
            }
            Constraint constraintClass = javaAnnotationType.getAnnotation(Constraint.class);
            Class<? extends ConstraintValidator> validatedBy = constraintClass != null ? constraintClass.validatedBy() : null;
            ClassMetadata.AnnotationMetadata annotationMetadata = ClassMetadata.AnnotationMetadata.builder().validatedBy(validatedBy).valuesByAnnotMethod(valuesByAnnotMethod).subAnnotations(Optional.ofNullable(subAnnotations).orElse(new ArrayList())).annotation(javaAnnotation).build();
            annotations.add(annotationMetadata);
        }
        return annotations;
    }
}

